/*
 * Decompiled with CFR 0.152.
 */
package excel.functions.plugins;

import excel.functions.macro.BioVoxxelMacroExtensionDescriptor;
import excel.functions.utils.ExcelUtils;
import ij.measure.ResultsTable;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BioVoxxel>Append table as columns")
public class AppendTableAsColumns
implements Command,
BioVoxxelMacroExtensionDescriptor {
    protected static final Logger logger = Logger.getLogger(ExcelUtils.class.getName());
    @Parameter(label="Results table name", description="if this field is empty the active table will be automatically used", required=false)
    private ResultsTable resultsTable;
    @Parameter(required=true)
    private File file;
    @Parameter(label="Sheet name", description="if empty the sheet will receive the name of the table used truncated at 30 characters if the title is >30 char", required=false)
    private String sheetName;
    @Parameter(label="Include table headings while appending")
    private Boolean includeTableHeadings = true;

    public void run() {
        if (this.resultsTable == null) {
            this.resultsTable = ExcelUtils.getActiveTable();
        }
        if (this.sheetName.equals("")) {
            this.sheetName = this.resultsTable.getTitle();
        }
        AppendTableAsColumns.appendTableAsColumns(this.resultsTable, this.file, this.sheetName, this.includeTableHeadings);
    }

    protected static void appendTableAsColumns(ResultsTable ijResultsTable, File workbookFile, String sheetNameOrIndexString, Boolean includeHeadings) {
        Workbook workbook;
        String[][] table2DArray = ExcelUtils.getIJTableAsRowColumn2DArray(ijResultsTable, includeHeadings);
        try {
            workbook = WorkbookFactory.create((File)workbookFile);
        }
        catch (EncryptedDocumentException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        logger.info("Workbook = " + workbook);
        Sheet sheet = ExcelUtils.getSheet(workbook, sheetNameOrIndexString);
        int columnCount = ExcelUtils.getColumnCount(sheet);
        ExcelUtils.write2DArrayToSheet(sheet, 0, columnCount, table2DArray);
        ExcelUtils.saveWorkbook(workbook, workbookFile);
    }

    @Override
    public String runFromMacro(Object[] parameters) {
        ExcelUtils.logMacroParameters(parameters);
        ResultsTable resultsTable = ExcelUtils.getIJResultsTable(parameters[0].toString());
        File workbookFile = new File(ExcelUtils.fixFilePath(parameters[1].toString()));
        String sheetName = parameters[2].toString();
        if (sheetName.equals("")) {
            sheetName = resultsTable.getTitle();
        }
        boolean includeHeadings = parameters[3].toString().equals("1") || parameters[3].toString().equalsIgnoreCase("true");
        AppendTableAsColumns.appendTableAsColumns(resultsTable, workbookFile, sheetName, includeHeadings);
        return "";
    }

    @Override
    public int[] parameterTypes() {
        return new int[]{1, 1, 1, 1};
    }

    @Override
    public String description() {
        return "Appends the specified or otherwise active table to an existing worksheet as new columns just behind the existing columns.";
    }

    @Override
    public String parameters() {
        return "ijResultsTableTitle, filePathToExcelWorkbook, sheetNameOrIndex, includeTableHeadings";
    }
}

