/*
 * Decompiled with CFR 0.152.
 */
package excel.functions.plugins;

import excel.functions.macro.BioVoxxelMacroExtensionDescriptor;
import excel.functions.utils.ExcelUtils;
import ij.measure.ResultsTable;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BioVoxxel>Save table as worksheet")
public class SaveTableAsWorksheet
implements Command,
BioVoxxelMacroExtensionDescriptor {
    protected static final Logger logger = Logger.getLogger(ExcelUtils.class.getName());
    @Parameter(label="Results table name", description="if this field is empty the active table will be automatically used", required=false)
    private ResultsTable selectedTable;
    @Parameter(required=true)
    private File file;
    @Parameter(label="Sheet name", description="if empty the sheet will receive the name of the table used truncated at 30 characters if the title is >30 char", required=false)
    private String sheetName;
    @Parameter(label="Skip headings while appending")
    private Boolean includeHeadings = true;

    public void run() {
        SaveTableAsWorksheet.saveTableAsWorkbookSheet(this.selectedTable, this.file, this.sheetName, this.includeHeadings);
    }

    protected static void saveTableAsWorkbookSheet(ResultsTable ijResultsTable, File workbookFile, String sheetName, Boolean includeColumnHeadings) {
        if (ijResultsTable == null) {
            JOptionPane.showMessageDialog(null, "No results table found", "No table found", 2);
            return;
        }
        logger.info("Current results table = " + ijResultsTable);
        String[][] table2DArray = ExcelUtils.getIJTableAsRowColumn2DArray(ijResultsTable, includeColumnHeadings);
        Workbook workbook = ExcelUtils.getWorkbook(workbookFile);
        logger.info("Workbook = " + workbook);
        if (workbook == null) {
            logger.info("Aborting due to nonexisting workbook");
            return;
        }
        Sheet sheet = ExcelUtils.getUniqueSheet(workbook, sheetName);
        logger.info("Current sheet = " + sheet);
        ExcelUtils.write2DArrayToSheet(sheet, 0, 0, table2DArray);
        ExcelUtils.saveWorkbook(workbook, workbookFile);
    }

    @Override
    public String runFromMacro(Object[] parameters) {
        ExcelUtils.logMacroParameters(parameters);
        ResultsTable resultsTable = ExcelUtils.getIJResultsTable(parameters[0].toString());
        File workbookFile = new File(ExcelUtils.fixFilePath(parameters[1].toString()));
        String sheetName = parameters[2].toString();
        if (sheetName.equals("")) {
            sheetName = resultsTable.getTitle();
        }
        boolean includeHeadings = parameters[3].toString().equals("1") || parameters[3].toString().equalsIgnoreCase("true");
        SaveTableAsWorksheet.saveTableAsWorkbookSheet(resultsTable, workbookFile, sheetName, includeHeadings);
        return "";
    }

    @Override
    public int[] parameterTypes() {
        return new int[]{1, 1, 1, 1};
    }

    @Override
    public String description() {
        return "The active or otherwise specified table will be saved as a single sheet in an Excel workbook (.xlsx) file under the specified name or the ImageJ table name otherwise.\nThis method will always create unique sheets in case the specified sheet name is already existing.\nIt will never overwrite any existing sheet.\nIf A table should be appended to an existing table use the corresponding methods.";
    }

    @Override
    public String parameters() {
        return "ijResultsTableTitle, filePathToExcelWorkbook, sheetName, includeColumnHeadings";
    }
}

