/*
 * Decompiled with CFR 0.152.
 */
package excel.functions.macro;

import excel.functions.macro.BioVoxxelMacroExtensionDescriptor;
import excel.functions.plugins.BioVoxxelPlugins;
import excel.functions.utils.ExcelUtils;
import ij.macro.ExtensionDescriptor;
import ij.macro.Functions;
import ij.macro.MacroExtension;
import java.util.logging.Level;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BioVoxxel>Excel Macro Extensions")
public class BioVoxxelMacroExtensions
implements Command,
MacroExtension {
    @Parameter(label="Debug logging", required=false)
    private boolean debuglogging;

    public void run() {
        if (this.debuglogging) {
            ExcelUtils.setupLogger(Level.ALL);
        } else {
            ExcelUtils.setupLogger(Level.OFF);
        }
        Functions.registerExtensions((MacroExtension)this);
    }

    public String handleExtension(String name, Object[] args) {
        BioVoxxelMacroExtensionDescriptor[] pluginList = BioVoxxelPlugins.list;
        String readout = "";
        for (BioVoxxelMacroExtensionDescriptor plugin : pluginList) {
            String command = "xlsx_" + plugin.getClass().getSimpleName();
            if (command.compareTo(name) != 0) continue;
            readout = plugin.runFromMacro(args);
            break;
        }
        return readout;
    }

    public ExtensionDescriptor[] getExtensionFunctions() {
        BioVoxxelMacroExtensionDescriptor[] pluginList = BioVoxxelPlugins.list;
        ExtensionDescriptor[] result = new ExtensionDescriptor[pluginList.length];
        int i = 0;
        for (BioVoxxelMacroExtensionDescriptor plugin : pluginList) {
            String call = "xlsx_" + plugin.getClass().getSimpleName();
            result[i] = new ExtensionDescriptor(call, plugin.parameterTypes(), (MacroExtension)this);
            ++i;
        }
        return result;
    }
}

