/*
 * Decompiled with CFR 0.152.
 */
package excel.functions.plugins;

import excel.functions.macro.BioVoxxelMacroExtensionDescriptor;
import excel.functions.utils.ExcelUtils;
import ij.WindowManager;
import ij.gui.Plot;
import ij.gui.PlotWindow;
import java.awt.Window;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xddf.usermodel.chart.ChartTypes;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BioVoxxel>Add Excel chart from Plot (experimental)")
public class AddExcelChartFromPlot
implements Command,
BioVoxxelMacroExtensionDescriptor {
    protected static final Logger logger = Logger.getLogger(ExcelUtils.class.getName());
    @Parameter(required=true)
    private File file;
    @Parameter(label="Sheet name", description="if empty the sheet will receive the name of the plot used truncated at 30 characters if the title is >30 char", required=false)
    private String sheetName;
    @Parameter(choices={"AREA", "AREA3D", "LINE", "LINE3D", "SCATTER"})
    private String charttype;

    public void run() {
        Plot plot = this.getActivePlot();
        AddExcelChartFromPlot.addExcelChartFromPlot(this.file, this.sheetName, plot, ChartTypes.valueOf((String)this.charttype));
    }

    private Plot getActivePlot() {
        Window window = WindowManager.getActiveWindow();
        Plot plot = null;
        if (window instanceof PlotWindow) {
            plot = ((PlotWindow)window).getPlot();
        }
        if (plot == null) {
            JOptionPane.showMessageDialog(window, "Active Window is not a Plot", "Not a Plot", 2);
        }
        return plot;
    }

    protected static void addExcelChartFromPlot(File workbookFile, String sheetNameOrIndexString, Plot plot, ChartTypes chartType) {
        Workbook workbook = ExcelUtils.getWorkbook(workbookFile);
        logger.info("Workbook = " + workbook);
        if (workbook == null) {
            logger.info("Aborting due to nonexisting workbook");
            return;
        }
        Sheet sheet = ExcelUtils.getSheet(workbook, sheetNameOrIndexString);
        logger.info("Current sheet = " + sheet);
        ExcelUtils.addExcelChartFromPlot(sheet, plot, chartType);
        ExcelUtils.saveWorkbook(workbook, workbookFile);
    }

    @Override
    public String runFromMacro(Object[] parameters) {
        ExcelUtils.logMacroParameters(parameters);
        File workbookFile = new File(ExcelUtils.fixFilePath(parameters[0].toString()));
        Plot plot = this.getActivePlot();
        String sheetName = parameters[1].toString();
        if (sheetName.equals("")) {
            sheetName = plot.getTitle();
        }
        ChartTypes chartType = ChartTypes.valueOf((String)parameters[2].toString());
        AddExcelChartFromPlot.addExcelChartFromPlot(workbookFile, sheetName, plot, chartType);
        return "";
    }

    @Override
    public int[] parameterTypes() {
        return new int[]{1, 1, 1};
    }

    @Override
    public String description() {
        return "This function takes the active plot window in ImageJ and converts the plot into an Excel chart.Currently, the functionality and chart types are still limited but once saved in Excel,it is easy to change the chart type. More functionalities are to come.Usable chart types need to be specified capitaliced and available are currently:AREA, AREA3D, LINE, LINE3D, SCATTER";
    }

    @Override
    public String parameters() {
        return "filePathToExcelWorkbook, sheetNameOrIndex, chartType";
    }
}

