/*
 * Decompiled with CFR 0.152.
 */
package excel.functions.plugins;

import excel.functions.plugins.AddExcelChartFromPlot;
import excel.functions.plugins.AddImageToWorksheet;
import excel.functions.plugins.AppendArrayAsExcelColumn;
import excel.functions.plugins.AppendArrayAsExcelRow;
import excel.functions.plugins.AppendTableAsColumns;
import excel.functions.plugins.AppendTableAsRows;
import excel.functions.plugins.DeleteWorkbookSheet;
import excel.functions.plugins.ImportXlsxWorksheetAsTable;
import excel.functions.plugins.SaveAllTablesToWorkbook;
import excel.functions.plugins.SaveTableAsWorksheet;
import excel.functions.plugins.SetColumnDataFormat;
import excel.functions.utils.ExcelUtils;
import ij.ImagePlus;
import ij.gui.Plot;
import ij.measure.ResultsTable;
import java.io.File;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xddf.usermodel.chart.ChartTypes;

public class ExcelFunctions {
    public static void saveTableToWorkbookSheet(ResultsTable ijResultsTable, File workbookFile, String sheetName, Boolean includeColumnHeadings) {
        SaveTableAsWorksheet.saveTableAsWorkbookSheet(ijResultsTable, workbookFile, sheetName, includeColumnHeadings);
    }

    public static void saveTableToWorkbookSheet(ResultsTable ijResultsTable, String filePathToXlsxWorkbookFile, String sheetName, Boolean includeColumnHeadings) {
        File workbookFile = new File(filePathToXlsxWorkbookFile);
        SaveTableAsWorksheet.saveTableAsWorkbookSheet(ijResultsTable, workbookFile, sheetName, includeColumnHeadings);
    }

    public static void saveTableToWorkbookSheet(ResultsTable ijResultsTable, File workbookFile) {
        String sheetName = ijResultsTable.getTitle();
        boolean includeColumnHeadings = true;
        SaveTableAsWorksheet.saveTableAsWorkbookSheet(ijResultsTable, workbookFile, sheetName, includeColumnHeadings);
    }

    public static void saveAllOpenTablesAsWorkbookSheets(File workbookFile, Boolean includeColumnHeadings) {
        SaveAllTablesToWorkbook.saveAllOpenTablesAsWorkbookSheets(workbookFile, includeColumnHeadings);
    }

    public static void saveAllOpenTablesAsWorkbookSheets(String filePathToXlsxWorkbookFile, Boolean includeColumnHeadings) {
        File workbookFile = new File(filePathToXlsxWorkbookFile);
        SaveAllTablesToWorkbook.saveAllOpenTablesAsWorkbookSheets(workbookFile, includeColumnHeadings);
    }

    public static void addImageToWorkbookSheet(ImagePlus imagePlus, File workbookFile) {
        Workbook workbook = ExcelUtils.getWorkbook(workbookFile);
        String imageName = imagePlus.getTitle();
        String sheetName = ExcelUtils.getUniqueSheetName(workbook, imageName);
        int column = 0;
        int row = 0;
        AddImageToWorksheet.addImageToWorksheet(imagePlus, workbookFile, sheetName, column, row);
    }

    public static void addImageToWorkbookSheet(ImagePlus imagePlus, File workbookFile, String sheetName, int column, int row) {
        AddImageToWorksheet.addImageToWorksheet(imagePlus, workbookFile, sheetName, column, row);
    }

    public static void addImageToWorkbookSheet(ImagePlus imagePlus, File workbookFile, int sheetIndex, int column, int row) {
        AddImageToWorksheet.addImageToWorksheet(imagePlus, workbookFile, "" + sheetIndex, column, row);
    }

    public static void appendArrayAsExcelRow(Number[] array, File workbookFile, String sheetName, int startingColumn) {
        String[] stringArray = ExcelFunctions.convertNumberArrayInStringArray(array);
        AppendArrayAsExcelRow.appendArrayAsTableRow(stringArray, workbookFile, sheetName, startingColumn);
    }

    public static void appendArrayAsExcelRow(Number[] array, File workbookFile, int sheetIndex, int startingColumn) {
        String[] stringArray = ExcelFunctions.convertNumberArrayInStringArray(array);
        AppendArrayAsExcelRow.appendArrayAsTableRow(stringArray, workbookFile, "" + sheetIndex, startingColumn);
    }

    public static void appendArrayAsExcelRow(String[] array, File workbookFile, String sheetName, int startingColumn) {
        AppendArrayAsExcelRow.appendArrayAsTableRow(array, workbookFile, sheetName, startingColumn);
    }

    public static void appendArrayAsExcelRow(String[] array, File workbookFile, int sheetIndex, int startingColumn) {
        AppendArrayAsExcelRow.appendArrayAsTableRow(array, workbookFile, "" + sheetIndex, startingColumn);
    }

    public static void appendArrayAsExcelColumn(Number[] array, File workbookFile, String sheetName, int startingRow) {
        String[] stringArray = ExcelFunctions.convertNumberArrayInStringArray(array);
        AppendArrayAsExcelColumn.appendArrayAsTableColumn(stringArray, workbookFile, sheetName, startingRow);
    }

    public static void appendArrayAsExcelColumn(Number[] array, File workbookFile, int sheetIndex, int startingRow) {
        String[] stringArray = ExcelFunctions.convertNumberArrayInStringArray(array);
        AppendArrayAsExcelColumn.appendArrayAsTableColumn(stringArray, workbookFile, "" + sheetIndex, startingRow);
    }

    public static void appendArrayAsExcelColumn(String[] array, File workbookFile, String sheetName, int startingRow) {
        AppendArrayAsExcelColumn.appendArrayAsTableColumn(array, workbookFile, sheetName, startingRow);
    }

    public static void appendArrayAsExcelColumn(String[] array, File workbookFile, int sheetIndex, int startingRow) {
        AppendArrayAsExcelColumn.appendArrayAsTableColumn(array, workbookFile, "" + sheetIndex, startingRow);
    }

    public static void setColumnDataFormat(File workbookFile, String sheetName, int columnNumber, String dataFormatString) {
        SetColumnDataFormat.setColumnDataFormat(workbookFile, sheetName, columnNumber, dataFormatString);
    }

    public static void setColumnDataFormat(File workbookFile, int sheetIndex, int columnNumber, String dataFormatString) {
        SetColumnDataFormat.setColumnDataFormat(workbookFile, "" + sheetIndex, columnNumber, dataFormatString);
    }

    public static void importXlsxWorksheetAsTable(File workbookFile, String sheetName, boolean useFirstRowAsHeading) {
        ImportXlsxWorksheetAsTable.importXlsxWorksheetAsTable(workbookFile, sheetName, useFirstRowAsHeading);
    }

    public static void importXlsxWorksheetAsTable(File workbookFile, int sheetIndex, boolean useFirstRowAsHeading) {
        ImportXlsxWorksheetAsTable.importXlsxWorksheetAsTable(workbookFile, "" + sheetIndex, useFirstRowAsHeading);
    }

    public static String getAllWorkbookSheetNames(File workbookFile) {
        return ExcelFunctions.getAllWorkbookSheetNames(workbookFile);
    }

    public static void appendTableAsColumns(ResultsTable ijResultsTable, File workbookFile, String sheetName, Boolean includeColumnHeadings) {
        AppendTableAsColumns.appendTableAsColumns(ijResultsTable, workbookFile, sheetName, includeColumnHeadings);
    }

    public static void appendTableAsColumns(ResultsTable ijResultsTable, File workbookFile, int sheetIndex, Boolean includeColumnHeadings) {
        AppendTableAsColumns.appendTableAsColumns(ijResultsTable, workbookFile, "" + sheetIndex, includeColumnHeadings);
    }

    public static void appendTableAsRows(ResultsTable ijResultsTable, File workbookFile, String sheetName, Boolean includeColumnHeadings) {
        AppendTableAsRows.appendTableAsRows(ijResultsTable, workbookFile, sheetName, includeColumnHeadings);
    }

    public static void appendTableAsRows(ResultsTable ijResultsTable, File workbookFile, int sheetIndex, Boolean includeColumnHeadings) {
        AppendTableAsRows.appendTableAsRows(ijResultsTable, workbookFile, "" + sheetIndex, includeColumnHeadings);
    }

    public static void deleteWorkbookSheet(File workbookFile, String sheetName) {
        DeleteWorkbookSheet.deleteWorkbookSheet(workbookFile, sheetName);
    }

    public static void deleteWorkbookSheet(File workbookFile, int sheetIndex) {
        DeleteWorkbookSheet.deleteWorkbookSheet(workbookFile, "" + sheetIndex);
    }

    public static void addPlotToWorksheet(File workbookFile, String sheetName, Plot plot, ChartTypes chartType) {
        AddExcelChartFromPlot.addExcelChartFromPlot(workbookFile, sheetName, plot, chartType);
    }

    public static void addPlotToWorksheet(File workbookFile, int sheetIndex, Plot plot, ChartTypes chartType) {
        AddExcelChartFromPlot.addExcelChartFromPlot(workbookFile, "" + sheetIndex, plot, chartType);
    }

    private static String[] convertNumberArrayInStringArray(Number[] array) {
        if (array != null) {
            String[] stringArray = new String[array.length];
            for (int index = 0; index < stringArray.length; ++index) {
                stringArray[index] = array[index].toString();
            }
            return stringArray;
        }
        return new String[0];
    }
}

