/*
 * Decompiled with CFR 0.152.
 */
package excel.functions.plugins;

import excel.functions.macro.BioVoxxelMacroExtensionDescriptor;
import excel.functions.plugins.SaveTableAsWorksheet;
import excel.functions.utils.ExcelUtils;
import ij.WindowManager;
import ij.measure.ResultsTable;
import java.io.File;
import java.util.logging.Logger;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BioVoxxel>Save all tables to workbook")
public class SaveAllTablesToWorkbook
implements Command,
BioVoxxelMacroExtensionDescriptor {
    protected static final Logger logger = Logger.getLogger(ExcelUtils.class.getName());
    @Parameter
    File file;
    @Parameter(label="Include table headings")
    private Boolean includeHeadings;

    public void run() {
        SaveAllTablesToWorkbook.saveAllOpenTablesAsWorkbookSheets(this.file, this.includeHeadings);
    }

    protected static void saveAllOpenTablesAsWorkbookSheets(File workbookFile, boolean includeHeadings) {
        String[] nonImageWindowNames = WindowManager.getNonImageTitles();
        logger.info("Non image windows: " + nonImageWindowNames);
        for (int window = 0; window < nonImageWindowNames.length; ++window) {
            ResultsTable currentTable = ResultsTable.getResultsTable((String)nonImageWindowNames[window]);
            logger.info("Current results table = " + currentTable);
            if (currentTable == null) continue;
            SaveTableAsWorksheet.saveTableAsWorkbookSheet(currentTable, workbookFile, nonImageWindowNames[window], includeHeadings);
        }
    }

    @Override
    public String runFromMacro(Object[] parameters) {
        ExcelUtils.logMacroParameters(parameters);
        File workbookFile = new File(ExcelUtils.fixFilePath(parameters[0].toString()));
        boolean includeHeadings = parameters[1].toString().equals("1") || parameters[1].toString().equalsIgnoreCase("true");
        SaveAllTablesToWorkbook.saveAllOpenTablesAsWorkbookSheets(workbookFile, includeHeadings);
        return "";
    }

    @Override
    public int[] parameterTypes() {
        return new int[]{1, 1};
    }

    @Override
    public String description() {
        return "Saves all open IJ results table as individual sheets to an XLSX Workbook.\nThe name of the table is used as sheet name and trunkated after 31 characters";
    }

    @Override
    public String parameters() {
        return "filePathToExcelWorkbook, includeColumnHeadings";
    }
}

