/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.collections.iterator.async;

import de.bixilon.kutil.collections.iterator.async.AsyncIterator;
import de.bixilon.kutil.concurrent.pool.DefaultThreadPool;
import de.bixilon.kutil.concurrent.pool.ThreadPool;
import de.bixilon.kutil.concurrent.pool.runnable.ForcePooledRunnable;
import de.bixilon.kutil.concurrent.pool.runnable.SimplePoolRunnable;
import de.bixilon.kutil.latch.AbstractLatch;
import de.bixilon.kutil.latch.SimpleLatch;
import java.util.Spliterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B=\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00120\u0014H\u0016J(\u0010\u0015\u001a\u00020\u0012*\b\u0012\u0004\u0012\u00028\u00000\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0002J\u0014\u0010\u0018\u001a\u00020\u00122\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004J6\u0010\u0019\u001a\u00020\u0012*\b\u0012\u0004\u0012\u00028\u00000\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00172\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00120\u0014H\u0002J6\u0010\u0019\u001a\u00020\u0012*\b\u0012\u0004\u0012\u00028\u00000\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\b2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00120\u0014H\u0002R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0016\u0010!\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010 R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010 \u00a8\u0006("}, d2={"Lde/bixilon/kutil/collections/iterator/async/QueuedIterator;", "T", "Lde/bixilon/kutil/collections/iterator/async/AsyncIterator;", "spliterator", "Ljava/util/Spliterator;", "pool", "Lde/bixilon/kutil/concurrent/pool/ThreadPool;", "priority", "", "threads", "queueSize", "<init>", "(Ljava/util/Spliterator;Lde/bixilon/kutil/concurrent/pool/ThreadPool;III)V", "createQueue", "Ljava/util/concurrent/ArrayBlockingQueue;", "estimated", "", "iterate", "", "executor", "Lkotlin/Function1;", "offer", "latch", "Lde/bixilon/kutil/latch/SimpleLatch;", "reuse", "work", "running", "fresh", "", "getPool", "()Lde/bixilon/kutil/concurrent/pool/ThreadPool;", "getPriority", "()I", "queue", "getQueueSize", "getSpliterator", "()Ljava/util/Spliterator;", "setSpliterator", "(Ljava/util/Spliterator;)V", "getThreads", "kutil"})
public final class QueuedIterator<T>
implements AsyncIterator<T> {
    @NotNull
    private Spliterator<T> spliterator;
    @NotNull
    private final ThreadPool pool;
    private final int priority;
    private final int threads;
    private final int queueSize;
    @Nullable
    private ArrayBlockingQueue<T> queue;
    private boolean fresh;

    public QueuedIterator(@NotNull Spliterator<T> spliterator, @NotNull ThreadPool pool, int priority, int threads, int queueSize) {
        Intrinsics.checkNotNullParameter(spliterator, (String)"spliterator");
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        this.spliterator = spliterator;
        this.pool = pool;
        this.priority = priority;
        this.threads = threads;
        this.queueSize = queueSize;
        this.fresh = true;
    }

    public /* synthetic */ QueuedIterator(Spliterator spliterator, ThreadPool threadPool, int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            threadPool = DefaultThreadPool.INSTANCE;
        }
        if ((n4 & 4) != 0) {
            n = 0;
        }
        if ((n4 & 8) != 0) {
            n2 = DefaultThreadPool.INSTANCE.getThreadCount();
        }
        if ((n4 & 0x10) != 0) {
            n3 = 0;
        }
        this(spliterator, threadPool, n, n2, n3);
    }

    @Override
    @NotNull
    public Spliterator<T> getSpliterator() {
        return this.spliterator;
    }

    public void setSpliterator(@NotNull Spliterator<T> spliterator) {
        Intrinsics.checkNotNullParameter(spliterator, (String)"<set-?>");
        this.spliterator = spliterator;
    }

    @NotNull
    public final ThreadPool getPool() {
        return this.pool;
    }

    public final int getPriority() {
        return this.priority;
    }

    public final int getThreads() {
        return this.threads;
    }

    public final int getQueueSize() {
        return this.queueSize;
    }

    public final void reuse(@NotNull Spliterator<T> spliterator) {
        Intrinsics.checkNotNullParameter(spliterator, (String)"spliterator");
        this.setSpliterator(spliterator);
        this.fresh = true;
    }

    private final ArrayBlockingQueue<T> createQueue(long estimated) {
        ArrayBlockingQueue<Object> queue;
        ArrayBlockingQueue<T> arrayBlockingQueue = queue = this.queue;
        if (arrayBlockingQueue != null) {
            return arrayBlockingQueue;
        }
        int size = this.queueSize > 0 ? this.queueSize : (estimated < 0L ? 100 : (estimated > 1000L ? 1000 : (int)estimated));
        this.queue = queue = new ArrayBlockingQueue(size);
        return queue;
    }

    private final void offer(ArrayBlockingQueue<T> $this$offer, SimpleLatch latch, Spliterator<T> spliterator) {
        this.pool.plusAssign(new ForcePooledRunnable(100, () -> QueuedIterator.offer$lambda$1(latch, spliterator, $this$offer)));
    }

    private final void work(ArrayBlockingQueue<T> $this$work, SimpleLatch latch, SimpleLatch running, Function1<? super T, Unit> executor) {
        while (true) {
            T element;
            if ((element = $this$work.poll(1L, TimeUnit.MICROSECONDS)) == null) {
                if (latch.get_count() == 0) break;
                continue;
            }
            executor.invoke(element);
        }
        running.dec();
    }

    private final void work(ArrayBlockingQueue<T> $this$work, SimpleLatch latch, int threads, Function1<? super T, Unit> executor) {
        SimpleLatch running = new SimpleLatch(threads);
        int n = running.getCount();
        for (int i = 0; i < n; ++i) {
            this.pool.plusAssign(new SimplePoolRunnable(this.priority, () -> QueuedIterator.work$lambda$2(this, $this$work, latch, running, executor)));
        }
        AbstractLatch.DefaultImpls.await$default(running, 0L, 1, null);
    }

    @Override
    public void iterate(@NotNull Function1<? super T, Unit> executor) {
        Intrinsics.checkNotNullParameter(executor, (String)"executor");
        if (!this.fresh) {
            throw new IllegalStateException("Spliterator is not fresh anymore!");
        }
        this.fresh = false;
        long estimated = this.getSpliterator().estimateSize();
        if (estimated == 0L) {
            return;
        }
        ArrayBlockingQueue<T> queue = this.createQueue(estimated);
        int capacity = queue.remainingCapacity();
        SimpleLatch latch = new SimpleLatch(2);
        this.offer(queue, latch, this.getSpliterator());
        AbstractLatch.DefaultImpls.awaitOrChange$default(latch, 0L, 1, null);
        this.work(queue, latch, capacity < this.threads ? capacity : this.threads, executor);
    }

    private static final void offer$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void offer$lambda$1(SimpleLatch $latch, Spliterator $spliterator, ArrayBlockingQueue $this_offer) {
        Intrinsics.checkNotNullParameter((Object)$latch, (String)"$latch");
        Intrinsics.checkNotNullParameter((Object)$spliterator, (String)"$spliterator");
        Intrinsics.checkNotNullParameter((Object)$this_offer, (String)"$this_offer");
        $latch.dec();
        $spliterator.forEachRemaining(arg_0 -> QueuedIterator.offer$lambda$1$lambda$0((Function1)new Function1<T, Unit>($this_offer){
            final /* synthetic */ ArrayBlockingQueue<T> $this_offer;
            {
                this.$this_offer = $receiver;
                super(1);
            }

            public final void invoke(@Nullable T it) {
                while (!this.$this_offer.offer(it)) {
                    Thread.sleep(1L);
                }
            }
        }, arg_0));
        $latch.dec();
    }

    private static final void work$lambda$2(QueuedIterator this$0, ArrayBlockingQueue $this_work, SimpleLatch $latch, SimpleLatch $running, Function1 $executor) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this_work, (String)"$this_work");
        Intrinsics.checkNotNullParameter((Object)$latch, (String)"$latch");
        Intrinsics.checkNotNullParameter((Object)$running, (String)"$running");
        Intrinsics.checkNotNullParameter((Object)$executor, (String)"$executor");
        this$0.work($this_work, $latch, $running, $executor);
    }
}

