/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.concurrent.schedule;

import de.bixilon.kutil.concurrent.schedule.SchedulerTask;
import de.bixilon.kutil.time.TimeUtil;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\n\u001a\u00020\u0003H\u0086\u0002J\t\u0010\u000b\u001a\u00020\u0003H\u0086\u0002J\t\u0010\f\u001a\u00020\u0003H\u0086\u0002J\t\u0010\r\u001a\u00020\u0007H\u0086\u0002J.\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0003H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u001a\u0010\u0019\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001bR\u001a\u0010\u001f\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u001bR\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u001bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001c\u0010,\u001a\u0004\u0018\u00010-X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101\u00a8\u00062"}, d2={"Lde/bixilon/kutil/concurrent/schedule/RepeatedTask;", "Lde/bixilon/kutil/concurrent/schedule/SchedulerTask;", "interval", "", "maxDelay", "priority", "runnable", "Ljava/lang/Runnable;", "<init>", "(IIILjava/lang/Runnable;)V", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "getNextRunDelay", "", "time", "hashCode", "toString", "", "executions", "getExecutions", "()I", "setExecutions", "(I)V", "getInterval", "lastExecution", "getLastExecution", "()J", "setLastExecution", "(J)V", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "getMaxDelay", "getPriority", "getRunnable", "()Ljava/lang/Runnable;", "thread", "Ljava/lang/Thread;", "getThread", "()Ljava/lang/Thread;", "setThread", "(Ljava/lang/Thread;)V", "kutil"})
public final class RepeatedTask
implements SchedulerTask {
    private final int interval;
    private final int maxDelay;
    private final int priority;
    @NotNull
    private final Runnable runnable;
    @NotNull
    private final ReentrantLock lock;
    @Nullable
    private Thread thread;
    private int executions;
    private long lastExecution;

    public RepeatedTask(int interval, int maxDelay, int priority, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        this.interval = interval;
        this.maxDelay = maxDelay;
        this.priority = priority;
        this.runnable = runnable;
        this.lock = new ReentrantLock();
        this.lastExecution = TimeUtil.INSTANCE.millis();
    }

    public /* synthetic */ RepeatedTask(int n, int n2, int n3, Runnable runnable, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            n2 = n - 1;
        }
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        this(n, n2, n3, runnable);
    }

    public final int getInterval() {
        return this.interval;
    }

    @Override
    public int getMaxDelay() {
        return this.maxDelay;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    @NotNull
    public Runnable getRunnable() {
        return this.runnable;
    }

    @NotNull
    public final ReentrantLock getLock() {
        return this.lock;
    }

    @Override
    @Nullable
    public Thread getThread() {
        return this.thread;
    }

    @Override
    public void setThread(@Nullable Thread thread) {
        this.thread = thread;
    }

    public final int getExecutions() {
        return this.executions;
    }

    public final void setExecutions(int n) {
        this.executions = n;
    }

    public final long getLastExecution() {
        return this.lastExecution;
    }

    public final void setLastExecution(long l) {
        this.lastExecution = l;
    }

    @Override
    public long getNextRunDelay(long time) {
        return this.lastExecution - time + (long)this.interval;
    }

    public final int component1() {
        return this.interval;
    }

    public final int component2() {
        return this.maxDelay;
    }

    public final int component3() {
        return this.priority;
    }

    @NotNull
    public final Runnable component4() {
        return this.runnable;
    }

    @NotNull
    public final RepeatedTask copy(int interval, int maxDelay, int priority, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        return new RepeatedTask(interval, maxDelay, priority, runnable);
    }

    public static /* synthetic */ RepeatedTask copy$default(RepeatedTask repeatedTask, int n, int n2, int n3, Runnable runnable, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = repeatedTask.interval;
        }
        if ((n4 & 2) != 0) {
            n2 = repeatedTask.maxDelay;
        }
        if ((n4 & 4) != 0) {
            n3 = repeatedTask.priority;
        }
        if ((n4 & 8) != 0) {
            runnable = repeatedTask.runnable;
        }
        return repeatedTask.copy(n, n2, n3, runnable);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RepeatedTask)) {
            return false;
        }
        RepeatedTask repeatedTask = (RepeatedTask)other;
        if (this.interval != repeatedTask.interval) {
            return false;
        }
        if (this.maxDelay != repeatedTask.maxDelay) {
            return false;
        }
        if (this.priority != repeatedTask.priority) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.runnable, (Object)repeatedTask.runnable);
    }

    public int hashCode() {
        int result = Integer.hashCode(this.interval);
        result = result * 31 + Integer.hashCode(this.maxDelay);
        result = result * 31 + Integer.hashCode(this.priority);
        result = result * 31 + this.runnable.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return "RepeatedTask(interval=" + this.interval + ", maxDelay=" + this.maxDelay + ", priority=" + this.priority + ", runnable=" + this.runnable + ')';
    }

    @Override
    public boolean isExecuting() {
        return SchedulerTask.DefaultImpls.isExecuting(this);
    }

    @Override
    public void interrupt() {
        SchedulerTask.DefaultImpls.interrupt(this);
    }
}

