/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.concurrent.schedule;

import de.bixilon.kutil.concurrent.lock.simple.SimpleLock;
import de.bixilon.kutil.concurrent.pool.DefaultThreadPool;
import de.bixilon.kutil.concurrent.pool.runnable.ForcePooledRunnable;
import de.bixilon.kutil.concurrent.schedule.QueuedTask;
import de.bixilon.kutil.concurrent.schedule.RepeatedTask;
import de.bixilon.kutil.concurrent.schedule.SchedulerTask;
import de.bixilon.kutil.reflection.ReflectionUtil;
import de.bixilon.kutil.shutdown.AbstractShutdownReason;
import de.bixilon.kutil.shutdown.ShutdownManager;
import de.bixilon.kutil.time.TimeUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0011\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0086\u0002J\u0011\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0086\u0002J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\f\u0010\u0014\u001a\u00020\u0005*\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0005H\u0002R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/bixilon/kutil/concurrent/schedule/TaskScheduler;", "", "<init>", "()V", "addTask", "", "task", "Lde/bixilon/kutil/concurrent/schedule/SchedulerTask;", "minusAssign", "plusAssign", "removeTask", "run", "queuedTime", "", "runLater", "Lde/bixilon/kutil/concurrent/schedule/QueuedTask;", "delay", "", "runnable", "Ljava/lang/Runnable;", "setOptions", "Ljava/lang/Thread;", "startChecking", "lock", "Lde/bixilon/kutil/concurrent/lock/simple/SimpleLock;", "tasks", "", "kutil"})
public final class TaskScheduler {
    @NotNull
    public static final TaskScheduler INSTANCE = new TaskScheduler();
    @NotNull
    private static final Set<SchedulerTask> tasks = new LinkedHashSet();
    @NotNull
    private static final SimpleLock lock = new SimpleLock();

    private TaskScheduler() {
    }

    private final void setOptions(Thread $this$setOptions) {
        $this$setOptions.setPriority(10);
        $this$setOptions.setUncaughtExceptionHandler(TaskScheduler::setOptions$lambda$1);
    }

    private final void startChecking() {
        while (true) {
            Iterator<SchedulerTask> iterator;
            lock.lock();
            long time = TimeUtil.INSTANCE.millis();
            Iterator<SchedulerTask> iterator2 = iterator = tasks.iterator();
            while (iterator2.hasNext()) {
                long due;
                SchedulerTask task = iterator2.next();
                if (task.isExecuting() || (due = task.getNextRunDelay(time)) > 0L) continue;
                DefaultThreadPool.INSTANCE.plusAssign(new ForcePooledRunnable(task.getPriority(), () -> TaskScheduler.startChecking$lambda$2(this, time, task)));
                if (!(task instanceof QueuedTask)) continue;
                iterator.remove();
            }
            lock.unlock();
            Thread.sleep(1L);
        }
    }

    private final void run(long queuedTime, SchedulerTask task) {
        long time;
        if (task instanceof RepeatedTask) {
            if (!((RepeatedTask)task).getLock().tryLock(1L, TimeUnit.MILLISECONDS)) {
                return;
            }
            if (((RepeatedTask)task).isExecuting()) {
                ((RepeatedTask)task).getLock().unlock();
                return;
            }
        }
        if ((time = TimeUtil.INSTANCE.millis()) - queuedTime >= (long)task.getMaxDelay()) {
            if (task instanceof RepeatedTask) {
                ((RepeatedTask)task).getLock().unlock();
            }
            return;
        }
        try {
            task.setThread(Thread.currentThread());
            task.getRunnable().run();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        task.setThread(null);
        if (task instanceof RepeatedTask) {
            int n = ((RepeatedTask)task).getExecutions();
            ((RepeatedTask)task).setExecutions(n + 1);
            ((RepeatedTask)task).setLastExecution(queuedTime);
            ((RepeatedTask)task).getLock().unlock();
        }
    }

    @NotNull
    public final QueuedTask runLater(int delay, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        QueuedTask task = new QueuedTask(delay, 0, 0, runnable, 6, null);
        this.addTask(task);
        return task;
    }

    public final void addTask(@NotNull SchedulerTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        lock.lock();
        ((Collection)tasks).add(task);
        lock.unlock();
    }

    public final void plusAssign(@NotNull SchedulerTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.addTask(task);
    }

    public final void removeTask(@NotNull SchedulerTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        lock.lock();
        ((Collection)tasks).remove(task);
        lock.unlock();
    }

    public final void minusAssign(@NotNull SchedulerTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.removeTask(task);
    }

    private static final void _init_$lambda$0() {
        Thread thread = Thread.currentThread();
        Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"currentThread(...)");
        INSTANCE.setOptions(thread);
        INSTANCE.startChecking();
    }

    private static final void setOptions$lambda$1(Thread thread, Throwable error) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        error.printStackTrace();
        ShutdownManager.INSTANCE.shutdown("TaskScheduler quit unexpectedly!", AbstractShutdownReason.Companion.getCRASH());
    }

    private static final void startChecking$lambda$2(TaskScheduler this$0, long $time, SchedulerTask $task) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
        this$0.run($time, $task);
    }

    static {
        new Thread(TaskScheduler::_init_$lambda$0, "TaskSchedulerThread").start();
        ReflectionUtil.INSTANCE.forceInit(DefaultThreadPool.class);
    }
}

