/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.concurrent.worker.task;

import de.bixilon.kutil.collections.CollectionUtil;
import de.bixilon.kutil.collections.map.SynchronizedMap;
import de.bixilon.kutil.collections.map.creator.MapCreator;
import de.bixilon.kutil.concurrent.lock.simple.SimpleLock;
import de.bixilon.kutil.concurrent.pool.DefaultThreadPool;
import de.bixilon.kutil.concurrent.pool.ThreadPool;
import de.bixilon.kutil.concurrent.pool.runnable.ForcePooledRunnable;
import de.bixilon.kutil.concurrent.pool.runnable.SimplePoolRunnable;
import de.bixilon.kutil.concurrent.pool.runnable.ThreadPoolRunnable;
import de.bixilon.kutil.concurrent.worker.WorkerStates;
import de.bixilon.kutil.concurrent.worker.task.TaskWorker;
import de.bixilon.kutil.concurrent.worker.task.WorkerTask;
import de.bixilon.kutil.latch.AbstractLatch;
import de.bixilon.kutil.latch.ParentLatch;
import de.bixilon.kutil.latch.SimpleLatch;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0002\u0018\u00002\u00020\u0001BU\u00128\b\u0002\u0010\u0002\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0003\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J&\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015H\u0002J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J5\u0010\u001e\u001a\u00020\n2%\u0010\u001c\u001a!\u0012\u0013\u0012\u00110!\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020\n0 j\u0002`\u001fH\u0086\u0002\u00a2\u0006\u0002\u0010#J\u0011\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0004H\u0086\u0002J\u0012\u0010$\u001a\u00020\n2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010!RJ\u0010\u0002\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010+\u001a\u00020*2\u0006\u0010)\u001a\u00020*@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u001a\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00040/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00100\u001a\b\u0012\u0004\u0012\u00020\u00040\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lde/bixilon/kutil/concurrent/worker/task/TaskWorker;", "", "errorHandler", "Lkotlin/Function2;", "Lde/bixilon/kutil/concurrent/worker/task/WorkerTask;", "Lkotlin/ParameterName;", "name", "task", "", "exception", "", "pool", "Lde/bixilon/kutil/concurrent/pool/ThreadPool;", "forcePool", "", "<init>", "(Lkotlin/jvm/functions/Function2;Lde/bixilon/kutil/concurrent/pool/ThreadPool;Z)V", "canWork", "lock", "Lde/bixilon/kutil/concurrent/lock/simple/SimpleLock;", "done", "", "collectTasks", "", "createRunnable", "Lde/bixilon/kutil/concurrent/pool/runnable/ThreadPoolRunnable;", "priority", "", "runnable", "Ljava/lang/Runnable;", "plusAssign", "Lde/bixilon/kutil/concurrent/worker/WorkerExecutor;", "Lkotlin/Function1;", "Lde/bixilon/kutil/latch/AbstractLatch;", "progress", "(Lkotlin/jvm/functions/Function1;)V", "work", "getErrorHandler", "()Lkotlin/jvm/functions/Function2;", "setErrorHandler", "(Lkotlin/jvm/functions/Function2;)V", "value", "Lde/bixilon/kutil/concurrent/worker/WorkerStates;", "state", "getState", "()Lde/bixilon/kutil/concurrent/worker/WorkerStates;", "tasks", "", "unnamedTasks", "kutil"})
@SourceDebugExtension(value={"SMAP\nTaskWorker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskWorker.kt\nde/bixilon/kutil/concurrent/worker/task/TaskWorker\n+ 2 CollectionUtil.kt\nde/bixilon/kutil/collections/CollectionUtil\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n48#2:140\n56#2:141\n1#3:142\n*S KotlinDebug\n*F\n+ 1 TaskWorker.kt\nde/bixilon/kutil/concurrent/worker/task/TaskWorker\n*L\n34#1:140\n35#1:141\n*E\n"})
public final class TaskWorker {
    @NotNull
    private Function2<? super WorkerTask, ? super Throwable, Unit> errorHandler;
    @NotNull
    private final ThreadPool pool;
    private final boolean forcePool;
    @NotNull
    private final Map<Object, WorkerTask> tasks;
    @NotNull
    private final List<WorkerTask> unnamedTasks;
    @NotNull
    private WorkerStates state;

    public TaskWorker(@NotNull Function2<? super WorkerTask, ? super Throwable, Unit> errorHandler, @NotNull ThreadPool pool, boolean forcePool) {
        Intrinsics.checkNotNullParameter(errorHandler, (String)"errorHandler");
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        this.errorHandler = errorHandler;
        this.pool = pool;
        this.forcePool = forcePool;
        CollectionUtil collectionUtil = CollectionUtil.INSTANCE;
        Pair[] pairs$iv = new Pair[]{};
        boolean $i$f$synchronizedMapOf = false;
        this.tasks = new SynchronizedMap(MapCreator.INSTANCE.uMutableMapOf(Arrays.copyOf(pairs$iv, pairs$iv.length)));
        CollectionUtil this_$iv = CollectionUtil.INSTANCE;
        WorkerTask[] values$iv = new WorkerTask[]{};
        boolean $i$f$synchronizedListOf = false;
        List list = Collections.synchronizedList(CollectionsKt.mutableListOf((Object[])Arrays.copyOf(values$iv, values$iv.length)));
        Intrinsics.checkNotNullExpressionValue(list, (String)"synchronizedList(...)");
        this.unnamedTasks = list;
        this.state = WorkerStates.PREPARING;
    }

    public /* synthetic */ TaskWorker(Function2 function2, ThreadPool threadPool, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function2 = 1.INSTANCE;
        }
        if ((n & 2) != 0) {
            threadPool = DefaultThreadPool.INSTANCE;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        this((Function2<? super WorkerTask, ? super Throwable, Unit>)function2, threadPool, bl);
    }

    @NotNull
    public final Function2<WorkerTask, Throwable, Unit> getErrorHandler() {
        return this.errorHandler;
    }

    public final void setErrorHandler(@NotNull Function2<? super WorkerTask, ? super Throwable, Unit> function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
        this.errorHandler = function2;
    }

    @NotNull
    public final WorkerStates getState() {
        return this.state;
    }

    public final void plusAssign(@NotNull WorkerTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (!(this.state == WorkerStates.PREPARING)) {
            boolean bl = false;
            String string = "Task worker is already working!";
            throw new IllegalStateException(string.toString());
        }
        if (ArraysKt.contains((Object[])task.getDependencies(), (Object)task.getIdentifier())) {
            throw new IllegalArgumentException("Task can not depend on itself!");
        }
        if (task.getIdentifier() != null) {
            WorkerTask previous = this.tasks.put(task.getIdentifier(), task);
            if (previous != null) {
                System.err.println("Task " + task.getIdentifier() + " replaced existing task!");
            }
        } else {
            ((Collection)this.unnamedTasks).add(task);
        }
    }

    public final void plusAssign(@NotNull Function1<? super AbstractLatch, Unit> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        this.plusAssign(new WorkerTask(null, false, 0, null, runnable, 15, null));
    }

    private final boolean canWork(WorkerTask task, SimpleLock lock, Set<? extends Object> done) {
        if (task.getDependencies().length == 0) {
            return true;
        }
        lock.acquire();
        for (Object dependency : task.getDependencies()) {
            if (done.contains(dependency)) continue;
            lock.release();
            return false;
        }
        lock.release();
        return true;
    }

    private final List<WorkerTask> collectTasks() {
        List tasks = CollectionsKt.toMutableList(this.tasks.values());
        CollectionsKt.addAll((Collection)tasks, (Iterable)this.unnamedTasks);
        CollectionsKt.sortWith((List)tasks, (arg_0, arg_1) -> TaskWorker.collectTasks$lambda$1(collectTasks.1.INSTANCE, arg_0, arg_1));
        return tasks;
    }

    public final synchronized void work(@Nullable AbstractLatch progress) {
        if (this.state != WorkerStates.PREPARING) {
            throw new IllegalStateException("Invalid state: " + (Object)((Object)this.state));
        }
        this.state = WorkerStates.WORKING;
        List<WorkerTask> tasks = this.collectTasks();
        Set done = new LinkedHashSet();
        SimpleLock doneLock = new SimpleLock();
        AbstractLatch workerProgress = progress == null ? (AbstractLatch)new SimpleLatch(1) : (AbstractLatch)new ParentLatch(1, progress);
        AtomicBoolean stop = new AtomicBoolean();
        while (!((Collection)tasks).isEmpty()) {
            Iterator<WorkerTask> iterator = tasks.iterator();
            int previousProgress = workerProgress.getCount();
            Iterator<WorkerTask> iterator2 = iterator;
            while (iterator2.hasNext()) {
                WorkerTask task = iterator2.next();
                if (!this.canWork(task, doneLock, done)) continue;
                iterator.remove();
                ParentLatch taskProgress = new ParentLatch(1, workerProgress);
                Runnable runnable = () -> TaskWorker.work$lambda$3(task, taskProgress, this, stop, doneLock, done);
                this.pool.plusAssign(this.createRunnable(task.getPriority(), runnable));
            }
            if (stop.get()) break;
            AbstractLatch.DefaultImpls.waitIfGreater$default(workerProgress, previousProgress, 0L, 2, null);
            if (!stop.get()) continue;
        }
        workerProgress.dec();
        AbstractLatch.DefaultImpls.await$default(workerProgress, 0L, 1, null);
        this.state = WorkerStates.FINISHED;
    }

    public static /* synthetic */ void work$default(TaskWorker taskWorker, AbstractLatch abstractLatch, int n, Object object) {
        if ((n & 1) != 0) {
            abstractLatch = null;
        }
        taskWorker.work(abstractLatch);
    }

    private final ThreadPoolRunnable createRunnable(int priority, Runnable runnable) {
        if (this.forcePool) {
            return new ForcePooledRunnable(priority, runnable);
        }
        return new SimplePoolRunnable(priority, runnable);
    }

    private static final int collectTasks$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final void work$lambda$3(WorkerTask $task, ParentLatch $taskProgress, TaskWorker this$0, AtomicBoolean $stop, SimpleLock $doneLock, Set $done) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
            Intrinsics.checkNotNullParameter((Object)$taskProgress, (String)"$taskProgress");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$stop, (String)"$stop");
            Intrinsics.checkNotNullParameter((Object)$doneLock, (String)"$doneLock");
            Intrinsics.checkNotNullParameter((Object)$done, (String)"$done");
            try {
                $task.getExecutor().invoke((Object)$taskProgress);
                $taskProgress.countDown();
            }
            catch (Throwable error) {
                this$0.errorHandler.invoke((Object)$task, (Object)error);
                $taskProgress.setCount(0);
                $stop.set(true);
                return;
            }
            Object object = $task.getIdentifier();
            if (object == null) break block2;
            Object it = object;
            boolean bl = false;
            $doneLock.lock();
            ((Collection)$done).add(it);
            $doneLock.unlock();
        }
    }

    public TaskWorker() {
        this(null, null, false, 7, null);
    }
}

