/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.concurrent.worker.unconditional;

import de.bixilon.kutil.collections.CollectionUtil;
import de.bixilon.kutil.concurrent.pool.DefaultThreadPool;
import de.bixilon.kutil.concurrent.pool.ThreadPool;
import de.bixilon.kutil.concurrent.pool.runnable.SimplePoolRunnable;
import de.bixilon.kutil.concurrent.worker.WorkerStates;
import de.bixilon.kutil.concurrent.worker.unconditional.UnconditionalTask;
import de.bixilon.kutil.concurrent.worker.unconditional.UnconditionalWorker;
import de.bixilon.kutil.latch.AbstractLatch;
import de.bixilon.kutil.latch.ParentLatch;
import de.bixilon.kutil.latch.SimpleLatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ2\u0010\t\u001a\u00020\n2%\u0010\u000b\u001a!\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\n0\rj\u0002`\f\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014J5\u0010\u0015\u001a\u00020\n2%\u0010\u000b\u001a!\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\n0\rj\u0002`\fH\u0086\u0002\u00a2\u0006\u0002\u0010\u0012J\u0011\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0086\u0002J\u0006\u0010\u0016\u001a\u00020\nJ\u0012\u0010\u0017\u001a\u00020\n2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00140#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001a\u00a8\u0006%"}, d2={"Lde/bixilon/kutil/concurrent/worker/unconditional/UnconditionalWorker;", "", "pool", "Lde/bixilon/kutil/concurrent/pool/ThreadPool;", "forcePool", "", "threadSafe", "<init>", "(Lde/bixilon/kutil/concurrent/pool/ThreadPool;ZZ)V", "add", "", "executor", "Lde/bixilon/kutil/concurrent/worker/WorkerExecutor;", "Lkotlin/Function1;", "Lde/bixilon/kutil/latch/AbstractLatch;", "Lkotlin/ParameterName;", "name", "progress", "(Lkotlin/jvm/functions/Function1;)V", "task", "Lde/bixilon/kutil/concurrent/worker/unconditional/UnconditionalTask;", "plusAssign", "reset", "work", "latch", "getForcePool", "()Z", "getPool", "()Lde/bixilon/kutil/concurrent/pool/ThreadPool;", "value", "Lde/bixilon/kutil/concurrent/worker/WorkerStates;", "state", "getState", "()Lde/bixilon/kutil/concurrent/worker/WorkerStates;", "tasks", "", "getThreadSafe", "kutil"})
@SourceDebugExtension(value={"SMAP\nUnconditionalWorker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnconditionalWorker.kt\nde/bixilon/kutil/concurrent/worker/unconditional/UnconditionalWorker\n+ 2 CollectionUtil.kt\nde/bixilon/kutil/collections/CollectionUtil\n*L\n1#1,91:1\n56#2:92\n*S KotlinDebug\n*F\n+ 1 UnconditionalWorker.kt\nde/bixilon/kutil/concurrent/worker/unconditional/UnconditionalWorker\n*L\n29#1:92\n*E\n"})
public final class UnconditionalWorker {
    @NotNull
    private final ThreadPool pool;
    private final boolean forcePool;
    private final boolean threadSafe;
    @NotNull
    private final List<UnconditionalTask> tasks;
    @NotNull
    private WorkerStates state;

    public UnconditionalWorker(@NotNull ThreadPool pool, boolean forcePool, boolean threadSafe) {
        List list;
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        this.pool = pool;
        this.forcePool = forcePool;
        this.threadSafe = threadSafe;
        if (this.threadSafe) {
            CollectionUtil collectionUtil = CollectionUtil.INSTANCE;
            UnconditionalTask[] values$iv = new UnconditionalTask[]{};
            boolean $i$f$synchronizedListOf = false;
            List list2 = Collections.synchronizedList(CollectionsKt.mutableListOf((Object[])Arrays.copyOf(values$iv, values$iv.length)));
            list = list2;
            Intrinsics.checkNotNullExpressionValue(list2, (String)"synchronizedList(...)");
        } else {
            list = new ArrayList();
        }
        this.tasks = list;
        this.state = WorkerStates.PREPARING;
    }

    public /* synthetic */ UnconditionalWorker(ThreadPool threadPool, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            threadPool = DefaultThreadPool.INSTANCE;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        this(threadPool, bl, bl2);
    }

    @NotNull
    public final ThreadPool getPool() {
        return this.pool;
    }

    public final boolean getForcePool() {
        return this.forcePool;
    }

    public final boolean getThreadSafe() {
        return this.threadSafe;
    }

    @NotNull
    public final WorkerStates getState() {
        return this.state;
    }

    public final void add(@NotNull UnconditionalTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (this.state != WorkerStates.PREPARING) {
            throw new IllegalStateException("Invalid state: " + (Object)((Object)this.state));
        }
        ((Collection)this.tasks).add(task);
    }

    public final void plusAssign(@NotNull UnconditionalTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.add(task);
    }

    public final void add(@NotNull Function1<? super AbstractLatch, Unit> executor) {
        Intrinsics.checkNotNullParameter(executor, (String)"executor");
        this.add(new UnconditionalTask(0, executor, 1, null));
    }

    public final void plusAssign(@NotNull Function1<? super AbstractLatch, Unit> executor) {
        Intrinsics.checkNotNullParameter(executor, (String)"executor");
        this.add(executor);
    }

    public final void work(@Nullable AbstractLatch latch) {
        if (this.state != WorkerStates.PREPARING) {
            throw new IllegalStateException("Invalid state: " + (Object)((Object)this.state));
        }
        this.state = WorkerStates.WORKING;
        AbstractLatch innerLatch = latch == null ? (AbstractLatch)new SimpleLatch(1) : (AbstractLatch)new ParentLatch(1, latch);
        CollectionsKt.sortWith(this.tasks, (arg_0, arg_1) -> UnconditionalWorker.work$lambda$0(work.1.INSTANCE, arg_0, arg_1));
        innerLatch.plus(this.tasks.size());
        SimpleLatch running = new SimpleLatch(0);
        for (UnconditionalTask task : this.tasks) {
            running.inc();
            if (!this.forcePool && (this.pool.isBusy() || this.pool.isBacklog())) {
                UnconditionalWorker.work$run(innerLatch, running, task.getExecutor());
            } else {
                this.pool.plusAssign(new SimplePoolRunnable(task.getPriority(), () -> UnconditionalWorker.work$lambda$1(task, innerLatch, running)));
            }
            AbstractLatch.DefaultImpls.waitIfGreater$default(running, this.pool.getThreadCount(), 0L, 2, null);
        }
        innerLatch.dec();
        AbstractLatch.DefaultImpls.await$default(innerLatch, 0L, 1, null);
        this.state = WorkerStates.FINISHED;
    }

    public static /* synthetic */ void work$default(UnconditionalWorker unconditionalWorker, AbstractLatch abstractLatch, int n, Object object) {
        if ((n & 1) != 0) {
            abstractLatch = null;
        }
        unconditionalWorker.work(abstractLatch);
    }

    public final void reset() {
        this.tasks.clear();
        this.state = WorkerStates.PREPARING;
    }

    private static final int work$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final void work$run(AbstractLatch innerLatch, SimpleLatch running, Function1<? super AbstractLatch, Unit> executor) {
        try {
            executor.invoke((Object)innerLatch);
        }
        catch (Throwable error) {
            error.printStackTrace();
        }
        innerLatch.dec();
        running.dec();
    }

    private static final void work$lambda$1(UnconditionalTask $task, AbstractLatch $innerLatch, SimpleLatch $running) {
        Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
        Intrinsics.checkNotNullParameter((Object)$innerLatch, (String)"$innerLatch");
        Intrinsics.checkNotNullParameter((Object)$running, (String)"$running");
        UnconditionalWorker.work$run($innerLatch, $running, $task.getExecutor());
    }

    public UnconditionalWorker() {
        this(null, false, false, 7, null);
    }
}

