/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.enums;

import de.bixilon.kutil.collections.map.creator.MapCreator;
import de.bixilon.kutil.enums.AliasableEnum;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00070\u0005\"\f\b\u0000\u0010\u0007*\u0006\u0012\u0002\b\u00030\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\n\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lde/bixilon/kutil/enums/EnumUtil;", "", "<init>", "()V", "getEnumValues", "", "", "T", "", "values", "", "([Ljava/lang/Enum;)Ljava/util/Map;", "kutil"})
public final class EnumUtil {
    @NotNull
    public static final EnumUtil INSTANCE = new EnumUtil();

    private EnumUtil() {
    }

    @NotNull
    public final <T extends Enum<?>> Map<String, T> getEnumValues(@NotNull T[] values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Map<String, T> names = MapCreator.INSTANCE.sMutableMapOf();
        for (T value : values) {
            String string = ((Enum)value).name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            names.put(string, value);
            if (!(value instanceof AliasableEnum)) continue;
            for (String name : ((AliasableEnum)value).getNames()) {
                names.put(name, value);
            }
        }
        return names;
    }
}

