/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.observer.list;

import de.bixilon.kutil.observer.list.ListChange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableList;
import kotlin.jvm.internal.markers.KMutableListIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010+\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001?B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\tJ\u001d\u0010\u0006\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000e\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0016J\u001e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0016J \u0010\u0011\u001a\u00020\n2\u0018\u0010\u0012\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0014\u0012\u0004\u0012\u00020\n0\u0013J\b\u0010\u0015\u001a\u00020\nH\u0016J\u0016\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0017\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0016J\u0013\u0010\u0018\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\u0016\u0010\u001b\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0096\u0002\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\fH\u0016J\u0015\u0010\u001e\u001a\u00020\f2\u0006\u0010\b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020\u0007H\u0016J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\"H\u0096\u0002J\u0015\u0010#\u001a\u00020\f2\u0006\u0010\b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000%H\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000%2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010&\u001a\u00020\n2\f\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0002J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000)H\u0016J\u0015\u0010*\u001a\u00020\u00072\u0006\u0010\b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\tJ\u0016\u0010+\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0016J\u0015\u0010,\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010-\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0016J\u001e\u0010.\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010/J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00028\u000001H\u0016J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000)H\u0016J\u001e\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u00104\u001a\u00020\f2\u0006\u00105\u001a\u00020\fH\u0016J\b\u00106\u001a\u000207H\u0016R&\u0010\u0012\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0014\u0012\u0004\u0012\u00020\n0\u00130\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00108\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R0\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\f\u0010;\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010\u0005\u00a8\u0006@"}, d2={"Lde/bixilon/kutil/observer/list/ObservedList;", "V", "", "unsafe", "<init>", "(Ljava/util/List;)V", "add", "", "element", "(Ljava/lang/Object;)Z", "", "index", "", "(ILjava/lang/Object;)V", "addAll", "elements", "", "addObserver", "observer", "Lkotlin/Function1;", "Lde/bixilon/kutil/observer/list/ListChange;", "clear", "contains", "containsAll", "equals", "other", "", "get", "(I)Ljava/lang/Object;", "hashCode", "indexOf", "(Ljava/lang/Object;)I", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "notifyObservers", "change", "parallelStream", "Ljava/util/stream/Stream;", "remove", "removeAll", "removeAt", "retainAll", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "spliterator", "Ljava/util/Spliterator;", "stream", "subList", "fromIndex", "toIndex", "toString", "", "size", "getSize", "()I", "value", "getUnsafe", "()Ljava/util/List;", "setUnsafe", "ListIterator", "kutil"})
public final class ObservedList<V>
implements List<V>,
KMutableList {
    @NotNull
    private final List<Function1<ListChange<V>, Unit>> observer;
    @NotNull
    private List<V> unsafe;

    public ObservedList(@NotNull List<V> unsafe) {
        Intrinsics.checkNotNullParameter(unsafe, (String)"unsafe");
        this.observer = new ArrayList();
        this.unsafe = unsafe;
    }

    public int getSize() {
        return this.unsafe.size();
    }

    @NotNull
    public final List<V> getUnsafe() {
        return this.unsafe;
    }

    public final void setUnsafe(@NotNull List<V> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (Intrinsics.areEqual(this.unsafe, value)) {
            return;
        }
        List<V> previous = this.unsafe;
        this.unsafe = value;
        this.notifyObservers(new ListChange((Collection)value, (Collection)previous));
    }

    public final void addObserver(@NotNull Function1<? super ListChange<V>, Unit> observer) {
        Intrinsics.checkNotNullParameter(observer, (String)"observer");
        ((Collection)this.observer).add(observer);
    }

    private final void notifyObservers(ListChange<V> change) {
        for (Function1<ListChange<V>, Unit> observer : this.observer) {
            observer.invoke(change);
        }
    }

    @Override
    public boolean contains(Object element) {
        return this.unsafe.contains(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.unsafe.containsAll(elements);
    }

    @Override
    public V get(int index) {
        return this.unsafe.get(index);
    }

    @Override
    public int indexOf(Object element) {
        return this.unsafe.indexOf(element);
    }

    @Override
    public boolean isEmpty() {
        return this.unsafe.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<V> iterator() {
        return new ListIterator(this.unsafe.listIterator());
    }

    @Override
    public int lastIndexOf(Object element) {
        return this.unsafe.lastIndexOf(element);
    }

    @Override
    public boolean add(V element) {
        this.notifyObservers(new ListChange(CollectionsKt.listOf(element), CollectionsKt.emptyList()));
        return this.unsafe.add(element);
    }

    @Override
    public void add(int index, V element) {
        this.notifyObservers(new ListChange(CollectionsKt.listOf(element), CollectionsKt.emptyList()));
        this.unsafe.add(index, element);
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends V> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        this.notifyObservers(new ListChange<V>(elements, CollectionsKt.emptyList()));
        return this.unsafe.addAll(index, elements);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends V> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        this.notifyObservers(new ListChange<V>(elements, CollectionsKt.emptyList()));
        return this.unsafe.addAll(elements);
    }

    @Override
    public void clear() {
        this.notifyObservers(new ListChange(CollectionsKt.emptyList(), CollectionsKt.toList((Iterable)this.unsafe)));
        this.unsafe.clear();
    }

    @Override
    @NotNull
    public java.util.ListIterator<V> listIterator() {
        return new ListIterator(this.unsafe.listIterator());
    }

    @Override
    @NotNull
    public java.util.ListIterator<V> listIterator(int index) {
        return new ListIterator(this.unsafe.listIterator(index));
    }

    @Override
    public boolean remove(Object element) {
        if (!this.unsafe.remove(element)) {
            return false;
        }
        this.notifyObservers(new ListChange(CollectionsKt.emptyList(), CollectionsKt.listOf((Object)element)));
        return true;
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        List contained = new ArrayList();
        for (Object object : elements) {
            if (!this.unsafe.contains(object)) continue;
            ((Collection)contained).add(object);
        }
        if (!this.unsafe.removeAll(elements)) {
            return false;
        }
        if (!((Collection)contained).isEmpty()) {
            this.notifyObservers(new ListChange(CollectionsKt.emptyList(), contained));
        }
        return true;
    }

    public V removeAt(int index) {
        V removed = this.unsafe.remove(index);
        this.notifyObservers(new ListChange(CollectionsKt.emptyList(), CollectionsKt.listOf(removed)));
        return removed;
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean removed = this.unsafe.retainAll(elements);
        this.notifyObservers(new ListChange<Object>(CollectionsKt.emptyList(), elements));
        return removed;
    }

    @Override
    public V set(int index, V element) {
        V previous = this.unsafe.set(index, element);
        this.notifyObservers(new ListChange(CollectionsKt.listOf(element), CollectionsKt.listOf(element)));
        return previous;
    }

    @Override
    @NotNull
    public List<V> subList(int fromIndex, int toIndex) {
        return this.unsafe.subList(fromIndex, toIndex);
    }

    @NotNull
    public String toString() {
        return this.unsafe.toString();
    }

    @Override
    public int hashCode() {
        return ((Object)this.unsafe).hashCode();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return Intrinsics.areEqual(this.unsafe, (Object)other);
    }

    @Override
    @NotNull
    public Spliterator<V> spliterator() {
        Spliterator<V> spliterator = this.unsafe.spliterator();
        Intrinsics.checkNotNullExpressionValue(spliterator, (String)"spliterator(...)");
        return spliterator;
    }

    @Override
    @NotNull
    public Stream<V> parallelStream() {
        Stream stream = this.unsafe.parallelStream();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"parallelStream(...)");
        return stream;
    }

    @Override
    @NotNull
    public Stream<V> stream() {
        Stream stream = this.unsafe.stream();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"stream(...)");
        return stream;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010+\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\bJ\t\u0010\t\u001a\u00020\nH\u0096\u0002J\b\u0010\u000b\u001a\u00020\nH\u0016J\u000e\u0010\f\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\r\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u0006H\u0016J\u0015\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\bR\u0012\u0010\u0014\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lde/bixilon/kutil/observer/list/ObservedList$ListIterator;", "", "iterator", "<init>", "(Lde/bixilon/kutil/observer/list/ObservedList;Ljava/util/ListIterator;)V", "add", "", "element", "(Ljava/lang/Object;)V", "hasNext", "", "hasPrevious", "next", "()Ljava/lang/Object;", "nextIndex", "", "previous", "previousIndex", "remove", "set", "current", "Ljava/lang/Object;", "kutil"})
    private final class ListIterator
    implements java.util.ListIterator<V>,
    KMutableListIterator {
        @NotNull
        private final java.util.ListIterator<V> iterator;
        @Nullable
        private V current;

        public ListIterator(java.util.ListIterator<V> iterator) {
            Intrinsics.checkNotNullParameter(iterator, (String)"iterator");
            this.iterator = iterator;
        }

        @Override
        public void remove() {
            Object v = this.current;
            if (v == null) {
                throw new IllegalStateException("Not iterating!");
            }
            Object current = v;
            this.iterator.remove();
            ObservedList.this.notifyObservers(new ListChange(SetsKt.emptySet(), SetsKt.setOf(current)));
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            Object value = this.iterator.next();
            this.current = value;
            return value;
        }

        @Override
        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        @Override
        public int nextIndex() {
            return this.iterator.nextIndex();
        }

        @Override
        public V previous() {
            Object value = this.iterator.previous();
            this.current = value;
            return value;
        }

        @Override
        public int previousIndex() {
            return this.iterator.previousIndex();
        }

        @Override
        public void add(V element) {
            this.iterator.add(element);
            ObservedList.this.notifyObservers(new ListChange(SetsKt.setOf(element), SetsKt.emptySet()));
        }

        @Override
        public void set(V element) {
            Object v = this.current;
            if (v == null) {
                throw new IllegalStateException("Not iterating!");
            }
            Object current = v;
            this.iterator.set(element);
            ObservedList.this.notifyObservers(new ListChange(SetsKt.setOf(element), SetsKt.setOf(current)));
        }
    }
}

