/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.rate;

import de.bixilon.kutil.collections.CollectionUtil;
import de.bixilon.kutil.collections.set.creator.SetCreator;
import de.bixilon.kutil.time.TimeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B5\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u001d\u0010\u000f\u001a\u00020\r2\u0010\u0010\u0010\u001a\f\u0012\u0004\u0012\u00020\r0\u0012j\u0002`\u0011\u00a2\u0006\u0002\u0010\u0013J\u001f\u0010\u0014\u001a\u00020\r2\u0010\u0010\u0010\u001a\f\u0012\u0004\u0012\u00020\r0\u0012j\u0002`\u0011H\u0002\u00a2\u0006\u0002\u0010\u0013J\u001d\u0010\u0015\u001a\u00020\u00072\u0010\u0010\u0010\u001a\f\u0012\u0004\u0012\u00020\r0\u0012j\u0002`\u0011\u00a2\u0006\u0002\u0010\u0016J \u0010\u0017\u001a\u00020\r2\u0010\u0010\u0010\u001a\f\u0012\u0004\u0012\u00020\r0\u0012j\u0002`\u0011H\u0086\u0002\u00a2\u0006\u0002\u0010\u0013J\u0006\u0010\u0018\u001a\u00020\rR\u0014\u0010\u0019\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR\u0011\u0010\u001d\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001bR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u000e\u0010\u000e\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010(\u001a\u0010\u0012\u0004\u0012\u00020\r\u0018\u00010\u0012j\u0004\u0018\u0001`\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010)R\u0011\u0010*\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u001b\u00a8\u0006,"}, d2={"Lde/bixilon/kutil/rate/RateLimiter;", "", "limit", "", "inTime", "", "allowForcePerform", "", "dependencies", "", "<init>", "(IJZLjava/util/Set;)V", "cleanup", "", "lock", "forcePerform", "action", "Lde/bixilon/kutil/rate/RateAction;", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)V", "internalPerform", "perform", "(Lkotlin/jvm/functions/Function0;)Z", "plusAssign", "work", "_canWork", "get_canWork", "()Z", "getAllowForcePerform", "canWork", "getCanWork", "getDependencies", "()Ljava/util/Set;", "executions", "", "getInTime", "()J", "getLimit", "()I", "Ljava/util/concurrent/locks/ReentrantLock;", "queued", "Lkotlin/jvm/functions/Function0;", "upToDate", "getUpToDate", "kutil"})
@SourceDebugExtension(value={"SMAP\nRateLimiter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RateLimiter.kt\nde/bixilon/kutil/rate/RateLimiter\n+ 2 CollectionUtil.kt\nde/bixilon/kutil/collections/CollectionUtil\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n52#2:131\n1#3:132\n*S KotlinDebug\n*F\n+ 1 RateLimiter.kt\nde/bixilon/kutil/rate/RateLimiter\n*L\n24#1:131\n*E\n"})
public final class RateLimiter {
    private final int limit;
    private final long inTime;
    private final boolean allowForcePerform;
    @NotNull
    private final Set<RateLimiter> dependencies;
    @NotNull
    private final ReentrantLock lock;
    @Nullable
    private Function0<Unit> queued;
    @NotNull
    private List<Long> executions;

    public RateLimiter(int limit, long inTime, boolean allowForcePerform, @NotNull Set<RateLimiter> dependencies) {
        Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
        this.limit = limit;
        this.inTime = inTime;
        this.allowForcePerform = allowForcePerform;
        this.dependencies = dependencies;
        this.lock = new ReentrantLock();
        this.executions = new ArrayList();
    }

    public /* synthetic */ RateLimiter(int n, long l, boolean bl, Set set, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 20;
        }
        if ((n2 & 2) != 0) {
            l = 1000L;
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        if ((n2 & 8) != 0) {
            CollectionUtil collectionUtil = CollectionUtil.INSTANCE;
            RateLimiter[] values$iv = new RateLimiter[]{};
            boolean $i$f$synchronizedSetOf = false;
            Set<RateLimiter> set2 = Collections.synchronizedSet(SetCreator.INSTANCE.uMutableSetOf(Arrays.copyOf(values$iv, values$iv.length)));
            Intrinsics.checkNotNullExpressionValue(set2, (String)"synchronizedSet(...)");
            set = set2;
        }
        this(n, l, bl, set);
    }

    public final int getLimit() {
        return this.limit;
    }

    public final long getInTime() {
        return this.inTime;
    }

    public final boolean getAllowForcePerform() {
        return this.allowForcePerform;
    }

    @NotNull
    public final Set<RateLimiter> getDependencies() {
        return this.dependencies;
    }

    public final boolean getUpToDate() {
        this.lock.lock();
        boolean upToDate = this.queued == null;
        this.lock.unlock();
        return upToDate;
    }

    public final boolean getCanWork() {
        this.cleanup(true);
        return this.executions.size() < this.limit;
    }

    private final boolean get_canWork() {
        this.cleanup(false);
        return this.executions.size() < this.limit;
    }

    public final boolean perform(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.lock.lock();
        if (!this.get_canWork()) {
            this.queued = action;
            this.lock.unlock();
            return false;
        }
        this.internalPerform(action);
        this.lock.unlock();
        return true;
    }

    public final void plusAssign(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.perform(action);
    }

    private final void internalPerform(Function0<Unit> action) {
        for (RateLimiter dependency : this.dependencies) {
            if (!dependency.getUpToDate()) {
                dependency.work();
            }
            if (dependency.getUpToDate()) continue;
            boolean bl = false;
            String string = "RateLimiter dependency is not upToDate!";
            throw new IllegalStateException(string.toString());
        }
        this.lock.lock();
        this.queued = null;
        try {
            action.invoke();
        }
        catch (Throwable error) {
            error.printStackTrace();
        }
        long time = TimeUtil.INSTANCE.millis();
        Long l = time;
        ((Collection)this.executions).add(l);
        this.lock.unlock();
    }

    public final void forcePerform(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (!this.allowForcePerform) {
            boolean bl = false;
            String string = "RateLimiter does not allow force performing!";
            throw new IllegalStateException(string.toString());
        }
        this.lock.lock();
        this.internalPerform(action);
        this.lock.unlock();
    }

    public final void work() {
        this.lock.lock();
        this.cleanup(false);
        if (!this.get_canWork()) {
            this.lock.unlock();
            return;
        }
        Function0<Unit> function0 = this.queued;
        if (function0 != null) {
            Function0<Unit> it = function0;
            boolean bl = false;
            this.internalPerform(it);
        }
        this.lock.unlock();
    }

    private final void cleanup(boolean lock) {
        long execution;
        long addDelta;
        if (lock) {
            this.lock.lock();
        }
        long time = TimeUtil.INSTANCE.millis();
        while (!((Collection)this.executions).isEmpty() && (addDelta = time - (execution = ((Number)CollectionsKt.first(this.executions)).longValue())) - this.inTime >= 0L) {
            CollectionsKt.removeFirst(this.executions);
        }
        if (lock) {
            this.lock.unlock();
        }
    }

    public RateLimiter() {
        this(0, 0L, false, null, 15, null);
    }
}

