/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.shutdown;

import de.bixilon.kutil.collections.CollectionUtil;
import de.bixilon.kutil.collections.set.creator.SetCreator;
import de.bixilon.kutil.concurrent.pool.DefaultThreadPool;
import de.bixilon.kutil.file.watcher.FileWatcherService;
import de.bixilon.kutil.shutdown.AbstractShutdownReason;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010\b\u001a\u00020\u0005H\u0002J\u0011\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0086\u0002J\u001c\u0010\n\u001a\u00020\u00052\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\r\u001a\u00020\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/bixilon/kutil/shutdown/ShutdownManager;", "", "<init>", "()V", "addHook", "", "hook", "Ljava/lang/Runnable;", "init", "plusAssign", "shutdown", "message", "", "reason", "Lde/bixilon/kutil/shutdown/AbstractShutdownReason;", "hooks", "", "initialized", "", "value", "shuttingDown", "getShuttingDown", "()Z", "viaHook", "kutil"})
@SourceDebugExtension(value={"SMAP\nShutdownManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShutdownManager.kt\nde/bixilon/kutil/shutdown/ShutdownManager\n+ 2 CollectionUtil.kt\nde/bixilon/kutil/collections/CollectionUtil\n*L\n1#1,76:1\n52#2:77\n*S KotlinDebug\n*F\n+ 1 ShutdownManager.kt\nde/bixilon/kutil/shutdown/ShutdownManager\n*L\n20#1:77\n*E\n"})
public final class ShutdownManager {
    @NotNull
    public static final ShutdownManager INSTANCE = new ShutdownManager();
    @NotNull
    private static final Set<Runnable> hooks;
    private static boolean initialized;
    private static volatile boolean shuttingDown;
    private static boolean viaHook;

    private ShutdownManager() {
    }

    public final boolean getShuttingDown() {
        return shuttingDown;
    }

    public final void shutdown(@Nullable String message, @NotNull AbstractShutdownReason reason) {
        String message2;
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        if (shuttingDown) {
            return;
        }
        shuttingDown = true;
        String string = message;
        if (string == null) {
            string = reason.getMessage();
        }
        if ((message2 = string) != null) {
            System.out.println((Object)("Shutting down: " + message2));
        } else {
            System.out.println((Object)"Shutting down...");
        }
        for (Runnable hook : hooks) {
            hook.run();
        }
        FileWatcherService.INSTANCE.stop();
        DefaultThreadPool.INSTANCE.shutdownNow();
        if (!viaHook) {
            System.exit(reason.getExitCode());
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    public static /* synthetic */ void shutdown$default(ShutdownManager shutdownManager, String string, AbstractShutdownReason abstractShutdownReason, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            abstractShutdownReason = AbstractShutdownReason.Companion.getDEFAULT();
        }
        shutdownManager.shutdown(string, abstractShutdownReason);
    }

    private final void init() {
        if (initialized) {
            return;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ShutdownManager.init$lambda$0(this), "Shutdown Hook"));
        initialized = true;
    }

    public final void addHook(@NotNull Runnable hook) {
        Intrinsics.checkNotNullParameter((Object)hook, (String)"hook");
        if (shuttingDown) {
            throw new IllegalStateException("Already shutting down!");
        }
        ((Collection)hooks).add(hook);
    }

    public final void plusAssign(@NotNull Runnable hook) {
        Intrinsics.checkNotNullParameter((Object)hook, (String)"hook");
        this.addHook(hook);
    }

    private static final void init$lambda$0(ShutdownManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (shuttingDown) {
            return;
        }
        viaHook = true;
        ShutdownManager.shutdown$default(this$0, null, null, 3, null);
    }

    static {
        CollectionUtil collectionUtil = CollectionUtil.INSTANCE;
        Runnable[] values$iv = new Runnable[]{};
        boolean $i$f$synchronizedSetOf = false;
        Set<Runnable> set = Collections.synchronizedSet(SetCreator.INSTANCE.uMutableSetOf(Arrays.copyOf(values$iv, values$iv.length)));
        Intrinsics.checkNotNullExpressionValue(set, (String)"synchronizedSet(...)");
        hooks = set;
        INSTANCE.init();
    }
}

