/*
 * KUtil
 * Copyright (C) 2021-2022 Moritz Zwerger
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

package de.bixilon.kutil.avg

interface Average<T> {
    val avgNanos: Long
    val default: T

    val avg: T

    fun add(value: T)

    operator fun plusAssign(value: T) {
        add(value)
    }


    fun cleanup(nanos: Long, data: MutableList<AvgEntry<T>>): Boolean {
        var updated = false
        val iterator = data.iterator()
        for (entry in iterator) {
            val delta = nanos - entry.time
            if (delta >= this.avgNanos) {
                iterator.remove()
                updated = true
            } else {
                break
            }
        }

        return updated
    }
}
