/*
 * KUtil
 * Copyright (C) 2021-2022 Moritz Zwerger
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

package de.bixilon.kutil.collections.iterator.async

import de.bixilon.kutil.concurrent.pool.DefaultThreadPool
import de.bixilon.kutil.concurrent.pool.ThreadPool
import java.util.*

interface AsyncIterator<T> {
    val spliterator: Spliterator<T>

    fun iterate(executor: (T) -> Unit)


    companion object {

        fun <T> Iterable<T>.async(pool: ThreadPool = DefaultThreadPool, priority: Int = ThreadPool.NORMAL, threads: Int = DefaultThreadPool.threadCount, executor: (T) -> Unit) {
            val spliterator = this.spliterator()
            val iterator = when {
                (spliterator.characteristics() and (Spliterator.CONCURRENT or Spliterator.IMMUTABLE) > 0) -> ConcurrentIterator(spliterator, pool, priority, threads)
                else -> QueuedIterator(spliterator, pool, priority, threads)
            }
            iterator.iterate(executor)
        }
    }
}
