/*
 * Minosoft
 * Copyright (C) 2020-2022 Moritz Zwerger
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * This software is not affiliated with Mojang AB, the original developer of Minecraft.
 */

package de.bixilon.kutil.collections.primitive

abstract class AbstractPrimitiveList<T> : Clearable {
    var finished: Boolean = false
        protected set
    abstract val limit: Int
    abstract val size: Int
    abstract val isEmpty: Boolean

    abstract fun ensureSize(needed: Int)
    // abstract fun add(value: T) // do not add, values will be wrapped in classes!

    abstract fun finish()


    protected fun checkFinished() {
        if (finished) {
            throw IllegalStateException("List is already finished!")
        }
    }
}
