/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.array;

import de.bixilon.kutil.cast.CastUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u0004\u0018\u00010\u0005\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00072\u0006\u0010\b\u001a\u0002H\u0006H\u0086\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J&\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0007\"\u0004\b\u0000\u0010\u0006*\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00060\u0007H\u0086\b\u00a2\u0006\u0002\u0010\rJ&\u0010\u000e\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0086\b\u00a2\u0006\u0002\u0010\u0010J.\u0010\u0011\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u0002H\u0006H\u0086\b\u00a2\u0006\u0002\u0010\u0012J\u001d\u0010\u0013\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u0006*\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00060\u0007\u00a2\u0006\u0002\u0010\u0014J\u001e\u0010\u0015\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u0007H\u0086\b\u00a2\u0006\u0002\u0010\u0016J\u001e\u0010\u0017\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u0007H\u0086\b\u00a2\u0006\u0002\u0010\u0016J(\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0007\"\u0006\b\u0000\u0010\u0006\u0018\u0001*\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00060\u0007H\u0086\b\u00a2\u0006\u0002\u0010\rJ#\u0010\u0019\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00072\u0006\u0010\u001a\u001a\u0002H\u0006\u00a2\u0006\u0002\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lde/bixilon/kutil/array/ArrayUtil;", "", "<init>", "()V", "index", "", "T", "", "value", "([Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Integer;", "modifyArrayIndex", "size", "cast", "([Ljava/lang/Object;)[Ljava/lang/Object;", "isIndex", "", "([Ljava/lang/Object;I)Z", "trySet", "([Ljava/lang/Object;ILjava/lang/Object;)Z", "isEmptyOrOnlyNull", "([Ljava/lang/Object;)Z", "getFirst", "([Ljava/lang/Object;)Ljava/lang/Object;", "getLast", "trim", "next", "current", "([Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "kutil"})
@SourceDebugExtension(value={"SMAP\nArrayUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrayUtil.kt\nde/bixilon/kutil/array/ArrayUtil\n+ 2 CastUtil.kt\nde/bixilon/kutil/cast/CastUtil\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n18#2:95\n37#3,2:96\n1#4:98\n*S KotlinDebug\n*F\n+ 1 ArrayUtil.kt\nde/bixilon/kutil/array/ArrayUtil\n*L\n40#1:95\n81#1:96,2\n*E\n"})
public final class ArrayUtil {
    @NotNull
    public static final ArrayUtil INSTANCE = new ArrayUtil();

    private ArrayUtil() {
    }

    @Nullable
    public final <T> Integer index(@NotNull T[] $this$index, T value) {
        Intrinsics.checkNotNullParameter($this$index, (String)"<this>");
        boolean $i$f$index = false;
        int index = ArraysKt.indexOf((Object[])$this$index, value);
        if (index < 0) {
            return null;
        }
        return index;
    }

    public final int modifyArrayIndex(int value, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be > 1: " + size);
        }
        int ret = value % size;
        if (ret < 0) {
            ret += size;
        }
        return ret;
    }

    @NotNull
    public final <T> T[] cast(@NotNull T[] $this$cast) {
        Intrinsics.checkNotNullParameter($this$cast, (String)"<this>");
        boolean $i$f$cast = false;
        CastUtil castUtil = CastUtil.INSTANCE;
        T[] $this$unsafeCast$iv = $this$cast;
        boolean $i$f$unsafeCast = false;
        return (Object[])((Object)$this$unsafeCast$iv);
    }

    public final <T> boolean isIndex(@NotNull T[] $this$isIndex, int index) {
        Intrinsics.checkNotNullParameter($this$isIndex, (String)"<this>");
        boolean $i$f$isIndex = false;
        return index >= 0 && index < $this$isIndex.length;
    }

    public final <T> boolean trySet(@NotNull T[] $this$trySet, int index, T value) {
        Intrinsics.checkNotNullParameter($this$trySet, (String)"<this>");
        boolean $i$f$trySet = false;
        if (index < 0 || index >= $this$trySet.length) {
            return false;
        }
        $this$trySet[index] = value;
        return true;
    }

    public final <T> boolean isEmptyOrOnlyNull(@NotNull T[] $this$isEmptyOrOnlyNull) {
        Intrinsics.checkNotNullParameter($this$isEmptyOrOnlyNull, (String)"<this>");
        for (T entry : $this$isEmptyOrOnlyNull) {
            if (entry == null) continue;
            return false;
        }
        return true;
    }

    public final <T> T getFirst(@NotNull T[] $this$getFirst) {
        Intrinsics.checkNotNullParameter($this$getFirst, (String)"<this>");
        boolean $i$f$getFirst = false;
        return $this$getFirst[0];
    }

    public final <T> T getLast(@NotNull T[] $this$getLast) {
        Intrinsics.checkNotNullParameter($this$getLast, (String)"<this>");
        boolean $i$f$getLast = false;
        return $this$getLast[ArraysKt.getLastIndex((Object[])$this$getLast)];
    }

    public final /* synthetic */ <T> T[] trim(T[] $this$trim) {
        Intrinsics.checkNotNullParameter($this$trim, (String)"<this>");
        boolean $i$f$trim = false;
        List list = new ArrayList($this$trim.length);
        for (T entry : $this$trim) {
            if (entry == null) continue;
            ((Collection)list).add(entry);
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Intrinsics.reifiedOperationMarker((int)0, (String)"T?");
        return thisCollection$iv.toArray(new Object[0]);
    }

    public final <T> T next(@NotNull T[] $this$next, T current) {
        Intrinsics.checkNotNullParameter($this$next, (String)"<this>");
        int index = ArraysKt.indexOf((Object[])$this$next, current);
        if (!(index >= 0)) {
            boolean bl = false;
            String string = "Array does not contain " + current;
            throw new IllegalStateException(string.toString());
        }
        if (index == $this$next.length - 1) {
            return $this$next[0];
        }
        return $this$next[index + 1];
    }
}

