/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.collections.iterator;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005B)\b\u0016\u0012\u001e\u0010\u0006\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020\u0007\"\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0004\b\u0004\u0010\bB\u001d\b\u0016\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020\t\u00a2\u0006\u0004\b\u0004\u0010\nJ\t\u0010\f\u001a\u00020\rH\u0096\u0002J\u000e\u0010\u000e\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0002H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/bixilon/kutil/collections/iterator/LinkedIterator;", "T", "", "iterator", "<init>", "(Ljava/util/Iterator;)V", "iterators", "", "([Ljava/util/Iterator;)V", "", "(Ljava/util/Collection;)V", "current", "hasNext", "", "next", "()Ljava/lang/Object;", "nextIterator", "kutil"})
public final class LinkedIterator<T>
implements Iterator<T>,
KMappedMarker {
    @NotNull
    private final Iterator<Iterator<T>> iterator;
    @Nullable
    private Iterator<? extends T> current;

    public LinkedIterator(@NotNull Iterator<? extends Iterator<? extends T>> iterator) {
        Intrinsics.checkNotNullParameter(iterator, (String)"iterator");
        this.iterator = iterator;
    }

    public LinkedIterator(Iterator<? extends T> ... iterators) {
        Intrinsics.checkNotNullParameter(iterators, (String)"iterators");
        this(ArrayIteratorKt.iterator((Object[])iterators));
    }

    public LinkedIterator(@NotNull Collection<? extends Iterator<? extends T>> iterators) {
        Intrinsics.checkNotNullParameter(iterators, (String)"iterators");
        this((Iterator<Iterator<T>>)iterators.iterator());
    }

    @Override
    public boolean hasNext() {
        if (this.current == null) {
            Iterator<T> iterator = this.nextIterator();
            if (iterator == null) {
                return false;
            }
            this.current = iterator;
        }
        while (this.current != null) {
            Iterator<T> iterator = this.current;
            Intrinsics.checkNotNull(iterator);
            if (iterator.hasNext()) {
                return true;
            }
            this.current = this.nextIterator();
        }
        return false;
    }

    @Override
    public T next() {
        Iterator<T> iterator = this.current;
        if (iterator == null) {
            throw new IllegalStateException("No iterator set!");
        }
        Iterator<T> iterator2 = iterator;
        return iterator2.next();
    }

    private final Iterator<T> nextIterator() {
        if (!this.iterator.hasNext()) {
            return null;
        }
        return this.iterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

