/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.collections.iterator.async;

import de.bixilon.kutil.concurrent.lock.simple.SimpleLock;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010(\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u000f*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u000fB\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\r\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u000eR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/bixilon/kutil/collections/iterator/async/SynchronizedIterator;", "T", "", "iterator", "", "<init>", "(Ljava/util/Iterator;)V", "getIterator", "()Ljava/util/Iterator;", "lock", "Lde/bixilon/kutil/concurrent/lock/simple/SimpleLock;", "ended", "", "getOrNull", "()Ljava/lang/Object;", "Companion", "kutil"})
public final class SynchronizedIterator<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Iterator<T> iterator;
    @NotNull
    private final SimpleLock lock;
    private boolean ended;

    public SynchronizedIterator(@NotNull Iterator<? extends T> iterator) {
        Intrinsics.checkNotNullParameter(iterator, (String)"iterator");
        this.iterator = iterator;
        this.lock = new SimpleLock();
    }

    @NotNull
    public final Iterator<T> getIterator() {
        return this.iterator;
    }

    @Nullable
    public final T getOrNull() {
        if (this.ended) {
            return null;
        }
        this.lock.lock();
        boolean hasNext = this.iterator.hasNext();
        if (!hasNext) {
            this.ended = true;
            this.lock.unlock();
            return null;
        }
        T next = this.iterator.next();
        this.lock.unlock();
        return next;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u0007\u00a8\u0006\b"}, d2={"Lde/bixilon/kutil/collections/iterator/async/SynchronizedIterator$Companion;", "", "<init>", "()V", "sync", "Lde/bixilon/kutil/collections/iterator/async/SynchronizedIterator;", "T", "", "kutil"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> SynchronizedIterator<T> sync(@NotNull Iterator<? extends T> $this$sync) {
            Intrinsics.checkNotNullParameter($this$sync, (String)"<this>");
            return new SynchronizedIterator<T>($this$sync);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

