/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.collections.primitive.floats;

import de.bixilon.kutil.collections.primitive.floats.AbstractFloatList;
import java.nio.FloatBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0007H\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u0001H\u0016J\b\u0010!\u001a\u00020\u0015H\u0002J\b\u0010\"\u001a\u00020\u0007H\u0016J\b\u0010#\u001a\u00020\u0015H\u0016J\b\u0010$\u001a\u00020\u0015H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\n\"\u0004\b\r\u0010\u0005R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lde/bixilon/kutil/collections/primitive/floats/HeapArrayFloatList;", "Lde/bixilon/kutil/collections/primitive/floats/AbstractFloatList;", "initialSize", "", "<init>", "(I)V", "data", "", "limit", "getLimit", "()I", "size", "getSize", "setSize", "isEmpty", "", "()Z", "nextGrowStep", "output", "outputUpToDate", "checkFinalized", "", "clear", "ensureSize", "needed", "grow", "add", "value", "", "array", "buffer", "Ljava/nio/FloatBuffer;", "floatList", "checkOutputArray", "toArray", "finish", "invalidateOutput", "kutil"})
public final class HeapArrayFloatList
extends AbstractFloatList {
    @NotNull
    private float[] data;
    private int size;
    private final int nextGrowStep;
    @NotNull
    private float[] output;
    private boolean outputUpToDate;

    public HeapArrayFloatList(int initialSize) {
        this.data = new float[initialSize];
        this.nextGrowStep = initialSize <= 0 ? 1000 : (initialSize <= 50 ? 50 : initialSize);
        this.output = new float[0];
    }

    public /* synthetic */ HeapArrayFloatList(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 1000;
        }
        this(n);
    }

    @Override
    public int getLimit() {
        return this.data.length;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    @Override
    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    private final void checkFinalized() {
        if (this.getFinished()) {
            throw new IllegalStateException("ArrayFloatList is already finalized!");
        }
    }

    @Override
    public void clear() {
        this.checkFinalized();
        this.setSize(0);
        this.invalidateOutput();
        this.output = new float[0];
    }

    @Override
    public void ensureSize(int needed) {
        this.checkFinalized();
        if (this.getLimit() - this.getSize() >= needed) {
            return;
        }
        int newSize = this.data.length;
        while (newSize - this.getSize() < needed) {
            newSize += this.nextGrowStep;
        }
        this.grow(newSize);
    }

    private final void grow(int size) {
        float[] oldData = this.data;
        this.data = new float[size];
        System.arraycopy(oldData, 0, this.data, 0, oldData.length);
    }

    @Override
    public void add(float value) {
        this.ensureSize(1);
        int n = this.getSize();
        this.setSize(n + 1);
        this.data[n] = value;
        this.invalidateOutput();
    }

    @Override
    public void add(@NotNull float[] array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.ensureSize(array.length);
        System.arraycopy(array, 0, this.data, this.getSize(), array.length);
        this.setSize(this.getSize() + array.length);
        this.invalidateOutput();
    }

    @Override
    public void add(@NotNull FloatBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int position = buffer.position();
        this.ensureSize(position);
        for (int i = 0; i < position; ++i) {
            this.data[this.getSize() + i] = buffer.get(i);
        }
        this.setSize(this.getSize() + position);
        this.invalidateOutput();
    }

    @Override
    public void add(@NotNull AbstractFloatList floatList) {
        Intrinsics.checkNotNullParameter((Object)floatList, (String)"floatList");
        this.ensureSize(floatList.getSize());
        float[] source = floatList instanceof HeapArrayFloatList ? (floatList.getFinished() ? ((HeapArrayFloatList)floatList).output : ((HeapArrayFloatList)floatList).data) : floatList.toArray();
        System.arraycopy(source, 0, this.data, this.getSize(), floatList.getSize());
        this.setSize(this.getSize() + floatList.getSize());
        this.invalidateOutput();
    }

    private final void checkOutputArray() {
        if (this.outputUpToDate) {
            return;
        }
        this.output = new float[this.getSize()];
        System.arraycopy(this.data, 0, this.output, 0, this.getSize());
        this.outputUpToDate = true;
    }

    @Override
    @NotNull
    public float[] toArray() {
        this.checkOutputArray();
        return this.output;
    }

    @Override
    public void finish() {
        this.setFinished(true);
        this.checkOutputArray();
        this.data = new float[0];
    }

    private final void invalidateOutput() {
        if (this.outputUpToDate) {
            this.outputUpToDate = false;
        }
    }

    public HeapArrayFloatList() {
        this(0, 1, null);
    }
}

