/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.collections.spliterator.async;

import de.bixilon.kutil.collections.spliterator.SpliteratorUtil;
import de.bixilon.kutil.collections.spliterator.async.AsyncSpliterator;
import de.bixilon.kutil.concurrent.pool.DefaultThreadPool;
import de.bixilon.kutil.concurrent.pool.ThreadPool;
import de.bixilon.kutil.concurrent.pool.runnable.SimplePoolRunnable;
import de.bixilon.kutil.latch.AbstractLatch;
import de.bixilon.kutil.latch.SimpleLatch;
import java.util.List;
import java.util.Spliterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B3\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ.\u0010\u0017\u001a\u00020\u0018*\b\u0012\u0004\u0012\u00028\u00000\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00180\u001cH\u0002J,\u0010\u0017\u001a\u00020\u0018*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u001d2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00180\u001cH\u0002J\u001c\u0010\u001e\u001a\u00020\u00182\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00180\u001cH\u0016J\u001c\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u001d2\u0006\u0010 \u001a\u00020!H\u0002R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lde/bixilon/kutil/collections/spliterator/async/ConcurrentSpliterator;", "T", "Lde/bixilon/kutil/collections/spliterator/async/AsyncSpliterator;", "spliterator", "Ljava/util/Spliterator;", "pool", "Lde/bixilon/kutil/concurrent/pool/ThreadPool;", "priority", "", "threads", "<init>", "(Ljava/util/Spliterator;Lde/bixilon/kutil/concurrent/pool/ThreadPool;II)V", "getSpliterator", "()Ljava/util/Spliterator;", "setSpliterator", "(Ljava/util/Spliterator;)V", "getPool", "()Lde/bixilon/kutil/concurrent/pool/ThreadPool;", "getPriority", "()I", "getThreads", "fresh", "", "work", "", "latch", "Lde/bixilon/kutil/latch/SimpleLatch;", "executor", "Lkotlin/Function1;", "", "iterate", "splits", "estimated", "", "kutil"})
public final class ConcurrentSpliterator<T>
implements AsyncSpliterator<T> {
    @NotNull
    private Spliterator<T> spliterator;
    @NotNull
    private final ThreadPool pool;
    private final int priority;
    private final int threads;
    private boolean fresh;

    public ConcurrentSpliterator(@NotNull Spliterator<T> spliterator, @NotNull ThreadPool pool, int priority, int threads) {
        Intrinsics.checkNotNullParameter(spliterator, (String)"spliterator");
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        this.spliterator = spliterator;
        this.pool = pool;
        this.priority = priority;
        this.threads = threads;
        this.fresh = true;
    }

    public /* synthetic */ ConcurrentSpliterator(Spliterator spliterator, ThreadPool threadPool, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            threadPool = DefaultThreadPool.INSTANCE;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = threadPool.getThreadCount();
        }
        this(spliterator, threadPool, n, n2);
    }

    @Override
    @NotNull
    public Spliterator<T> getSpliterator() {
        return this.spliterator;
    }

    public void setSpliterator(@NotNull Spliterator<T> spliterator) {
        Intrinsics.checkNotNullParameter(spliterator, (String)"<set-?>");
        this.spliterator = spliterator;
    }

    @NotNull
    public final ThreadPool getPool() {
        return this.pool;
    }

    public final int getPriority() {
        return this.priority;
    }

    public final int getThreads() {
        return this.threads;
    }

    private final void work(Spliterator<T> $this$work, SimpleLatch latch, Function1<? super T, Unit> executor) {
        $this$work.forEachRemaining(arg_0 -> ConcurrentSpliterator.work$lambda$0(executor, arg_0));
        latch.dec();
    }

    private final void work(List<? extends Spliterator<T>> $this$work, Function1<? super T, Unit> executor) {
        SimpleLatch latch = new SimpleLatch($this$work.size());
        for (Spliterator<T> split : $this$work) {
            this.pool.plusAssign(new SimplePoolRunnable(this.priority, () -> ConcurrentSpliterator.work$lambda$1(this, split, latch, executor)));
        }
        AbstractLatch.DefaultImpls.await$default(latch, 0L, 1, null);
    }

    @Override
    public void iterate(@NotNull Function1<? super T, Unit> executor) {
        Intrinsics.checkNotNullParameter(executor, (String)"executor");
        if (!this.fresh) {
            throw new IllegalStateException("Spliterator is not fresh anymore!");
        }
        this.fresh = false;
        long estimated = this.getSpliterator().estimateSize();
        if (estimated == 0L) {
            return;
        }
        List<Spliterator<T>> splits = this.splits(estimated);
        this.work(splits, executor);
    }

    private final List<Spliterator<T>> splits(long estimated) {
        int count = (int)estimated;
        if (count > this.threads || count < 0) {
            count = this.threads;
        }
        return SpliteratorUtil.INSTANCE.split(this.getSpliterator(), count, estimated);
    }

    private static final void work$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void work$lambda$1(ConcurrentSpliterator this$0, Spliterator $split, SimpleLatch $latch, Function1 $executor) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$split, (String)"$split");
        Intrinsics.checkNotNullParameter((Object)$latch, (String)"$latch");
        Intrinsics.checkNotNullParameter((Object)$executor, (String)"$executor");
        this$0.work($split, $latch, $executor);
    }
}

