/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.concurrent.pool;

import de.bixilon.kutil.concurrent.lock.simple.SimpleLock;
import de.bixilon.kutil.concurrent.pool.runnable.ThreadPoolRunnable;
import java.util.Collection;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004J\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lde/bixilon/kutil/concurrent/pool/PoolSubmitter;", "", "queue", "Ljava/util/concurrent/PriorityBlockingQueue;", "Lde/bixilon/kutil/concurrent/pool/runnable/ThreadPoolRunnable;", "running", "Ljava/util/concurrent/atomic/AtomicInteger;", "count", "", "<init>", "(Ljava/util/concurrent/PriorityBlockingQueue;Ljava/util/concurrent/atomic/AtomicInteger;I)V", "getQueue", "()Ljava/util/concurrent/PriorityBlockingQueue;", "getRunning", "()Ljava/util/concurrent/atomic/AtomicInteger;", "getCount", "()I", "lock", "Lde/bixilon/kutil/concurrent/lock/simple/SimpleLock;", "getLock", "()Lde/bixilon/kutil/concurrent/lock/simple/SimpleLock;", "submit", "", "runnable", "forceSubmit", "kutil"})
public final class PoolSubmitter {
    @NotNull
    private final PriorityBlockingQueue<ThreadPoolRunnable> queue;
    @NotNull
    private final AtomicInteger running;
    private final int count;
    @NotNull
    private final SimpleLock lock;

    public PoolSubmitter(@NotNull PriorityBlockingQueue<ThreadPoolRunnable> queue, @NotNull AtomicInteger running, int count) {
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)running, (String)"running");
        this.queue = queue;
        this.running = running;
        this.count = count;
        this.lock = new SimpleLock();
    }

    @NotNull
    public final PriorityBlockingQueue<ThreadPoolRunnable> getQueue() {
        return this.queue;
    }

    @NotNull
    public final AtomicInteger getRunning() {
        return this.running;
    }

    public final int getCount() {
        return this.count;
    }

    @NotNull
    public final SimpleLock getLock() {
        return this.lock;
    }

    public final boolean submit(@NotNull ThreadPoolRunnable runnable) {
        boolean submit;
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        this.lock.lock();
        boolean bl = submit = runnable.getForcePool() || this.queue.size() == 0 && this.running.get() < this.count;
        if (!submit) {
            this.lock.unlock();
            return false;
        }
        ((Collection)this.queue).add(runnable);
        this.lock.unlock();
        return true;
    }

    public final boolean forceSubmit(@NotNull ThreadPoolRunnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        this.lock.lock();
        ((Collection)this.queue).add(runnable);
        this.lock.unlock();
        return true;
    }
}

