/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.concurrent.schedule;

import de.bixilon.kutil.concurrent.schedule.SchedulerTask;
import de.bixilon.kutil.time.TimeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0011H\u0016J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001J\t\u0010$\u001a\u00020%H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006&"}, d2={"Lde/bixilon/kutil/concurrent/schedule/QueuedTask;", "Lde/bixilon/kutil/concurrent/schedule/SchedulerTask;", "delay", "", "maxDelay", "priority", "runnable", "Ljava/lang/Runnable;", "<init>", "(IIILjava/lang/Runnable;)V", "getDelay", "()I", "getMaxDelay", "getPriority", "getRunnable", "()Ljava/lang/Runnable;", "created", "", "thread", "Ljava/lang/Thread;", "getThread", "()Ljava/lang/Thread;", "setThread", "(Ljava/lang/Thread;)V", "getNextRunDelay", "time", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "toString", "", "kutil"})
public final class QueuedTask
implements SchedulerTask {
    private final int delay;
    private final int maxDelay;
    private final int priority;
    @NotNull
    private final Runnable runnable;
    private final long created;
    @Nullable
    private Thread thread;

    public QueuedTask(int delay, int maxDelay, int priority, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        this.delay = delay;
        this.maxDelay = maxDelay;
        this.priority = priority;
        this.runnable = runnable;
        this.created = TimeUtil.INSTANCE.millis();
    }

    public /* synthetic */ QueuedTask(int n, int n2, int n3, Runnable runnable, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            n2 = Integer.MAX_VALUE;
        }
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        this(n, n2, n3, runnable);
    }

    public final int getDelay() {
        return this.delay;
    }

    @Override
    public int getMaxDelay() {
        return this.maxDelay;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    @NotNull
    public Runnable getRunnable() {
        return this.runnable;
    }

    @Override
    @Nullable
    public Thread getThread() {
        return this.thread;
    }

    @Override
    public void setThread(@Nullable Thread thread) {
        this.thread = thread;
    }

    @Override
    public long getNextRunDelay(long time) {
        return this.created - time + (long)this.delay;
    }

    public final int component1() {
        return this.delay;
    }

    public final int component2() {
        return this.maxDelay;
    }

    public final int component3() {
        return this.priority;
    }

    @NotNull
    public final Runnable component4() {
        return this.runnable;
    }

    @NotNull
    public final QueuedTask copy(int delay, int maxDelay, int priority, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        return new QueuedTask(delay, maxDelay, priority, runnable);
    }

    public static /* synthetic */ QueuedTask copy$default(QueuedTask queuedTask, int n, int n2, int n3, Runnable runnable, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = queuedTask.delay;
        }
        if ((n4 & 2) != 0) {
            n2 = queuedTask.maxDelay;
        }
        if ((n4 & 4) != 0) {
            n3 = queuedTask.priority;
        }
        if ((n4 & 8) != 0) {
            runnable = queuedTask.runnable;
        }
        return queuedTask.copy(n, n2, n3, runnable);
    }

    @NotNull
    public String toString() {
        return "QueuedTask(delay=" + this.delay + ", maxDelay=" + this.maxDelay + ", priority=" + this.priority + ", runnable=" + this.runnable + ')';
    }

    public int hashCode() {
        int result = Integer.hashCode(this.delay);
        result = result * 31 + Integer.hashCode(this.maxDelay);
        result = result * 31 + Integer.hashCode(this.priority);
        result = result * 31 + this.runnable.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof QueuedTask)) {
            return false;
        }
        QueuedTask queuedTask = (QueuedTask)other;
        if (this.delay != queuedTask.delay) {
            return false;
        }
        if (this.maxDelay != queuedTask.maxDelay) {
            return false;
        }
        if (this.priority != queuedTask.priority) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.runnable, (Object)queuedTask.runnable);
    }

    @Override
    public boolean isExecuting() {
        return SchedulerTask.DefaultImpls.isExecuting(this);
    }

    @Override
    public void interrupt() {
        SchedulerTask.DefaultImpls.interrupt(this);
    }
}

