/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.concurrent.schedule;

import de.bixilon.kutil.concurrent.schedule.SchedulerTask;
import de.bixilon.kutil.time.TimeUtil;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u001fH\u0016J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u0007H\u00c6\u0003J1\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u000100H\u00d6\u0003J\t\u00101\u001a\u00020\u0003H\u00d6\u0001J\t\u00102\u001a\u000203H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u000b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u00064"}, d2={"Lde/bixilon/kutil/concurrent/schedule/RepeatedTask;", "Lde/bixilon/kutil/concurrent/schedule/SchedulerTask;", "interval", "", "maxDelay", "priority", "runnable", "Ljava/lang/Runnable;", "<init>", "(IIILjava/lang/Runnable;)V", "getInterval", "()I", "getMaxDelay", "getPriority", "getRunnable", "()Ljava/lang/Runnable;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "thread", "Ljava/lang/Thread;", "getThread", "()Ljava/lang/Thread;", "setThread", "(Ljava/lang/Thread;)V", "executions", "getExecutions", "setExecutions", "(I)V", "lastExecution", "", "getLastExecution", "()J", "setLastExecution", "(J)V", "enqueue", "", "getNextRunDelay", "time", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "toString", "", "kutil"})
public final class RepeatedTask
implements SchedulerTask {
    private final int interval;
    private final int maxDelay;
    private final int priority;
    @NotNull
    private final Runnable runnable;
    @NotNull
    private final ReentrantLock lock;
    @Nullable
    private Thread thread;
    private int executions;
    private long lastExecution;

    public RepeatedTask(int interval, int maxDelay, int priority, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        this.interval = interval;
        this.maxDelay = maxDelay;
        this.priority = priority;
        this.runnable = runnable;
        this.lock = new ReentrantLock();
        this.lastExecution = TimeUtil.INSTANCE.millis();
    }

    public /* synthetic */ RepeatedTask(int n, int n2, int n3, Runnable runnable, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            n2 = n - 1;
        }
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        this(n, n2, n3, runnable);
    }

    public final int getInterval() {
        return this.interval;
    }

    @Override
    public int getMaxDelay() {
        return this.maxDelay;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    @NotNull
    public Runnable getRunnable() {
        return this.runnable;
    }

    @NotNull
    public final ReentrantLock getLock() {
        return this.lock;
    }

    @Override
    @Nullable
    public Thread getThread() {
        return this.thread;
    }

    @Override
    public void setThread(@Nullable Thread thread) {
        this.thread = thread;
    }

    public final int getExecutions() {
        return this.executions;
    }

    public final void setExecutions(int n) {
        this.executions = n;
    }

    public final long getLastExecution() {
        return this.lastExecution;
    }

    public final void setLastExecution(long l) {
        this.lastExecution = l;
    }

    public final void enqueue() {
        this.lastExecution = -1L;
    }

    @Override
    public long getNextRunDelay(long time) {
        return this.lastExecution - time + (long)this.interval;
    }

    public final int component1() {
        return this.interval;
    }

    public final int component2() {
        return this.maxDelay;
    }

    public final int component3() {
        return this.priority;
    }

    @NotNull
    public final Runnable component4() {
        return this.runnable;
    }

    @NotNull
    public final RepeatedTask copy(int interval, int maxDelay, int priority, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        return new RepeatedTask(interval, maxDelay, priority, runnable);
    }

    public static /* synthetic */ RepeatedTask copy$default(RepeatedTask repeatedTask, int n, int n2, int n3, Runnable runnable, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = repeatedTask.interval;
        }
        if ((n4 & 2) != 0) {
            n2 = repeatedTask.maxDelay;
        }
        if ((n4 & 4) != 0) {
            n3 = repeatedTask.priority;
        }
        if ((n4 & 8) != 0) {
            runnable = repeatedTask.runnable;
        }
        return repeatedTask.copy(n, n2, n3, runnable);
    }

    @NotNull
    public String toString() {
        return "RepeatedTask(interval=" + this.interval + ", maxDelay=" + this.maxDelay + ", priority=" + this.priority + ", runnable=" + this.runnable + ')';
    }

    public int hashCode() {
        int result = Integer.hashCode(this.interval);
        result = result * 31 + Integer.hashCode(this.maxDelay);
        result = result * 31 + Integer.hashCode(this.priority);
        result = result * 31 + this.runnable.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RepeatedTask)) {
            return false;
        }
        RepeatedTask repeatedTask = (RepeatedTask)other;
        if (this.interval != repeatedTask.interval) {
            return false;
        }
        if (this.maxDelay != repeatedTask.maxDelay) {
            return false;
        }
        if (this.priority != repeatedTask.priority) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.runnable, (Object)repeatedTask.runnable);
    }

    @Override
    public boolean isExecuting() {
        return SchedulerTask.DefaultImpls.isExecuting(this);
    }

    @Override
    public void interrupt() {
        SchedulerTask.DefaultImpls.interrupt(this);
    }
}

