/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.exception;

import java.io.PrintWriter;
import java.io.StringWriter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JT\u0010\u0004\u001a\u0004\u0018\u0001H\u0005\"\u0004\b\u0000\u0010\u00052$\b\u0002\u0010\u0006\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b0\u0007\"\n\u0012\u0006\b\u0001\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000b\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0002 \u0001\u00a2\u0006\u0002\u0010\fJ4\u0010\r\u001a\u0004\u0018\u0001H\u0005\"\u0004\b\u0000\u0010\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000bH\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0002\u0010\u000eJ4\u0010\u000f\u001a\u0004\u0018\u0001H\u0005\"\u0004\b\u0000\u0010\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000bH\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0002\u0010\u000eJ\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u000bH\u0086\b\u00f8\u0001\u0000J\n\u0010\u0015\u001a\u00020\u0016*\u00020\t\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0017"}, d2={"Lde/bixilon/kutil/exception/ExceptionUtil;", "", "<init>", "()V", "tryCatch", "T", "exceptions", "", "Ljava/lang/Class;", "", "executor", "Lkotlin/Function0;", "([Ljava/lang/Class;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "catchAll", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "ignoreAll", "retry", "", "tries", "", "block", "toStackTrace", "", "kutil"})
public final class ExceptionUtil {
    @NotNull
    public static final ExceptionUtil INSTANCE = new ExceptionUtil();

    private ExceptionUtil() {
    }

    @Nullable
    public final <T> T tryCatch(@NotNull Class<? extends Throwable>[] exceptions, @NotNull Function0<? extends T> executor) {
        Intrinsics.checkNotNullParameter(exceptions, (String)"exceptions");
        Intrinsics.checkNotNullParameter(executor, (String)"executor");
        try {
            return (T)executor.invoke();
        }
        catch (Throwable thrown) {
            for (Class<? extends Throwable> exception : exceptions) {
                if (!exception.isAssignableFrom(thrown.getClass())) continue;
                return null;
            }
            throw thrown;
        }
    }

    public static /* synthetic */ Object tryCatch$default(ExceptionUtil exceptionUtil, Class[] classArray, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            classArray = new Class[]{};
        }
        return exceptionUtil.tryCatch(classArray, function0);
    }

    @Nullable
    public final <T> T catchAll(@NotNull Function0<? extends T> executor) {
        Intrinsics.checkNotNullParameter(executor, (String)"executor");
        boolean $i$f$catchAll = false;
        try {
            return (T)executor.invoke();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Nullable
    public final <T> T ignoreAll(@NotNull Function0<? extends T> executor) {
        Intrinsics.checkNotNullParameter(executor, (String)"executor");
        boolean $i$f$ignoreAll = false;
        try {
            return (T)executor.invoke();
        }
        catch (Throwable error) {
            error.printStackTrace();
            return null;
        }
    }

    public final void retry(int tries, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$retry = false;
        if (tries < 1) {
            throw new IllegalArgumentException("Invalid number of tries: " + tries);
        }
        Throwable thrown = null;
        for (int i = 0; i < tries; ++i) {
            try {
                block.invoke();
                return;
            }
            catch (Throwable error) {
                thrown = error;
                continue;
            }
        }
        Throwable throwable = thrown;
        Intrinsics.checkNotNull(throwable);
        throw throwable;
    }

    @NotNull
    public final String toStackTrace(@NotNull Throwable $this$toStackTrace) {
        Intrinsics.checkNotNullParameter((Object)$this$toStackTrace, (String)"<this>");
        StringWriter stringWriter = new StringWriter();
        $this$toStackTrace.printStackTrace(new PrintWriter(stringWriter));
        String string = stringWriter.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

