/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.file.watcher;

import de.bixilon.kutil.cast.CastUtil;
import de.bixilon.kutil.concurrent.lock.simple.SimpleLock;
import de.bixilon.kutil.concurrent.pool.DefaultThreadPool;
import de.bixilon.kutil.exception.ExceptionUtil;
import de.bixilon.kutil.file.watcher.WatchKeyPair;
import de.bixilon.kutil.file.watcher.Watcher;
import de.bixilon.kutil.file.watcher.WatcherCallback;
import de.bixilon.kutil.latch.AbstractLatch;
import de.bixilon.kutil.latch.SimpleLatch;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0012\u001a\u00020\u000fJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\f\u0010\u0017\u001a\u00020\u0014*\u00020\u000bH\u0002J*\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eJ*\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\f\u001a\u00020\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lde/bixilon/kutil/file/watcher/FileWatcherService;", "", "<init>", "()V", "lock", "Lde/bixilon/kutil/concurrent/lock/simple/SimpleLock;", "path", "", "Lde/bixilon/kutil/file/watcher/WatchKeyPair;", "Lde/bixilon/kutil/file/watcher/Watcher;", "key", "Ljava/nio/file/WatchKey;", "stop", "", "service", "Ljava/nio/file/WatchService;", "thread", "Ljava/lang/Thread;", "start", "startThread", "", "latch", "Lde/bixilon/kutil/latch/AbstractLatch;", "poll", "watchAsync", "Ljava/nio/file/Path;", "kind", "", "Ljava/nio/file/WatchEvent$Kind;", "callback", "Lde/bixilon/kutil/file/watcher/WatcherCallback;", "watch", "kutil"})
@SourceDebugExtension(value={"SMAP\nFileWatcherService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileWatcherService.kt\nde/bixilon/kutil/file/watcher/FileWatcherService\n+ 2 ExceptionUtil.kt\nde/bixilon/kutil/exception/ExceptionUtil\n+ 3 CastUtil.kt\nde/bixilon/kutil/cast/CastUtil\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,150:1\n56#2,6:151\n56#2,2:161\n58#2,4:164\n56#2,2:168\n58#2,4:171\n27#3,4:157\n18#3:163\n18#3:170\n37#4,2:175\n381#5,7:177\n*S KotlinDebug\n*F\n+ 1 FileWatcherService.kt\nde/bixilon/kutil/file/watcher/FileWatcherService\n*L\n63#1:151,6\n94#1:161,2\n94#1:164,4\n100#1:168,2\n100#1:171,4\n88#1:157,4\n94#1:163\n100#1:170\n126#1:175,2\n136#1:177,7\n*E\n"})
public final class FileWatcherService {
    @NotNull
    public static final FileWatcherService INSTANCE = new FileWatcherService();
    @NotNull
    private static final SimpleLock lock = new SimpleLock();
    @NotNull
    private static final Map<WatchKeyPair, Watcher> path = new HashMap();
    @NotNull
    private static final Map<WatchKey, Watcher> key = new HashMap();
    private static boolean stop;
    @Nullable
    private static WatchService service;
    private static Thread thread;

    private FileWatcherService() {
    }

    @NotNull
    public final WatchService start() {
        lock.lock();
        if (service != null) {
            lock.unlock();
            WatchService watchService = service;
            Intrinsics.checkNotNull((Object)watchService);
            return watchService;
        }
        stop = false;
        SimpleLatch latch = new SimpleLatch(1);
        thread = new Thread(() -> FileWatcherService.start$lambda$0(latch), "FileWatcherService");
        Thread thread = FileWatcherService.thread;
        if (thread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"thread");
            thread = null;
        }
        thread.start();
        AbstractLatch.DefaultImpls.await$default(latch, 0L, 1, null);
        lock.unlock();
        WatchService watchService = service;
        Intrinsics.checkNotNull((Object)watchService);
        return watchService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startThread(AbstractLatch latch) {
        try {
            WatchService service;
            FileWatcherService.service = service = FileSystems.getDefault().newWatchService();
            latch.dec();
            while (true) {
                WatchKey key = service.take();
                if (stop) break;
                lock.lock();
                ExceptionUtil this_$iv = ExceptionUtil.INSTANCE;
                boolean $i$f$ignoreAll = false;
                try {
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)key);
                    INSTANCE.poll(key);
                }
                catch (Throwable error$iv) {
                    error$iv.printStackTrace();
                }
                lock.unlock();
                key.reset();
            }
            for (WatchKey key : FileWatcherService.key.keySet()) {
                key.cancel();
            }
            key.clear();
            path.clear();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (latch.getCount() > 0) {
                latch.dec();
            }
            service = null;
        }
    }

    private final void poll(WatchKey $this$poll) {
        Watcher watcher = key.get($this$poll);
        if (watcher == null) {
            return;
        }
        Watcher watcher2 = watcher;
        watcher2.getLock().acquire();
        List<WatchEvent<?>> events = $this$poll.pollEvents();
        for (WatchEvent<?> event : events) {
            List<WatcherCallback> files;
            Path path = null;
            CastUtil castUtil = CastUtil.INSTANCE;
            Object $this$nullCast$iv = event.context();
            boolean $i$f$nullCast = false;
            Path path2 = (Path)($this$nullCast$iv instanceof Path ? $this$nullCast$iv : null);
            if (path2 == null) continue;
            path = path2;
            if (!path.startsWith(watcher2.getPath())) {
                path = watcher2.getPath().resolve(path);
            }
            for (WatcherCallback directory : watcher2.getDirectory()) {
                ExceptionUtil this_$iv = ExceptionUtil.INSTANCE;
                boolean $i$f$ignoreAll = false;
                try {
                    boolean bl = false;
                    CastUtil castUtil2 = CastUtil.INSTANCE;
                    WatchEvent.Kind<?> $this$unsafeCast$iv = event.kind();
                    boolean $i$f$unsafeCast = false;
                    directory.onFileChange((WatchEvent.Kind)((Object)$this$unsafeCast$iv), path);
                }
                catch (Throwable error$iv) {
                    error$iv.printStackTrace();
                }
            }
            Object object = path.getFileName();
            if (object == null || (object = object.toString()) == null) {
                return;
            }
            Object filename = object;
            if (watcher2.getFiles().get(filename) == null) continue;
            for (WatcherCallback file : files) {
                ExceptionUtil this_$iv = ExceptionUtil.INSTANCE;
                boolean $i$f$ignoreAll = false;
                try {
                    boolean bl = false;
                    CastUtil $i$f$unsafeCast = CastUtil.INSTANCE;
                    WatchEvent.Kind<?> $this$unsafeCast$iv = event.kind();
                    boolean $i$f$unsafeCast2 = false;
                    file.onFileChange((WatchEvent.Kind)((Object)$this$unsafeCast$iv), path);
                }
                catch (Throwable error$iv) {
                    error$iv.printStackTrace();
                }
            }
        }
        watcher2.getLock().release();
    }

    public final void watchAsync(@NotNull Path path, @NotNull Set<? extends WatchEvent.Kind<Path>> kind, @NotNull WatcherCallback callback) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        DefaultThreadPool.INSTANCE.plusAssign(() -> FileWatcherService.watchAsync$lambda$4(path, kind, callback));
    }

    public final synchronized void watch(@NotNull Path path, @NotNull Set<? extends WatchEvent.Kind<Path>> kind, @NotNull WatcherCallback callback) {
        File file;
        WatchService service;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        WatchService watchService = FileWatcherService.service;
        if (watchService == null) {
            watchService = service = this.start();
        }
        if ((file = path.toFile()).isFile()) {
            file = file.getParentFile();
        }
        if (!file.isDirectory()) {
            throw new IllegalStateException("Can not watch directory: " + file);
        }
        Path path2 = file.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
        WatchKeyPair keyPair = new WatchKeyPair(path2, kind);
        lock.lock();
        Watcher watcher = FileWatcherService.path.get(keyPair);
        if (watcher == null) {
            Collection $this$toTypedArray$iv = kind;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            WatchKey key = keyPair.getPath().register(service, thisCollection$iv.toArray(new WatchEvent.Kind[0]), new WatchEvent.Modifier[0]);
            Intrinsics.checkNotNull((Object)key);
            watcher = new Watcher(key, keyPair.getPath(), null, null, 12, null);
            FileWatcherService.key.put(key, watcher);
            FileWatcherService.path.put(keyPair, watcher);
        }
        watcher.getLock().lock();
        if (Intrinsics.areEqual((Object)keyPair.getPath(), (Object)path)) {
            ((Collection)watcher.getDirectory()).add(callback);
        } else {
            List list;
            String filename = ((Object)path.getFileName()).toString();
            Map<String, List<WatcherCallback>> $this$getOrPut$iv = watcher.getFiles();
            boolean $i$f$getOrPut = false;
            List value$iv = $this$getOrPut$iv.get(filename);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(filename, answer$iv);
                list = answer$iv;
            } else {
                list = value$iv;
            }
            ((Collection)list).add(callback);
        }
        watcher.getLock().unlock();
        lock.unlock();
    }

    public final void stop() {
        if (service == null) {
            return;
        }
        stop = true;
        Thread thread = FileWatcherService.thread;
        if (thread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"thread");
            thread = null;
        }
        thread.interrupt();
    }

    private static final void start$lambda$0(SimpleLatch $latch) {
        Intrinsics.checkNotNullParameter((Object)$latch, (String)"$latch");
        INSTANCE.startThread($latch);
    }

    private static final void watchAsync$lambda$4(Path $path, Set $kind, WatcherCallback $callback) {
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        Intrinsics.checkNotNullParameter((Object)$kind, (String)"$kind");
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        INSTANCE.watch($path, $kind, $callback);
    }
}

