/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.hash;

import de.bixilon.kutil.array.ByteArrayUtil;
import de.bixilon.kutil.buffer.ByteBufferUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\b\u001a\u00020\u0005*\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\n\u0010\f\u001a\u00020\u0005*\u00020\u000bJ\n\u0010\f\u001a\u00020\u0005*\u00020\rJ\n\u0010\u000e\u001a\u00020\u0005*\u00020\u000bJ\n\u0010\u000e\u001a\u00020\u0005*\u00020\rJ\n\u0010\u000f\u001a\u00020\u0005*\u00020\u000bJ\n\u0010\u000f\u001a\u00020\u0005*\u00020\rJ\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lde/bixilon/kutil/hash/HashUtil;", "", "<init>", "()V", "SHA_1", "", "SHA_256", "SHA_512", "hash", "Ljava/security/MessageDigest;", "input", "Ljava/io/InputStream;", "sha1", "", "sha256", "sha512", "murmur64", "", "kutil"})
public final class HashUtil {
    @NotNull
    public static final HashUtil INSTANCE = new HashUtil();
    @NotNull
    public static final String SHA_1 = "SHA-1";
    @NotNull
    public static final String SHA_256 = "SHA-256";
    @NotNull
    public static final String SHA_512 = "SHA-512";

    private HashUtil() {
    }

    private final String hash(MessageDigest $this$hash, InputStream input) {
        byte[] buffer = ByteBufferUtil.createBuffer$default(ByteBufferUtil.INSTANCE, 0, 1, null);
        int length = 0;
        while ((length = input.read(buffer, 0, buffer.length)) >= 0) {
            $this$hash.update(buffer, 0, length);
        }
        byte[] byArray = $this$hash.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return ByteArrayUtil.INSTANCE.toHex(byArray);
    }

    @NotNull
    public final String sha1(@NotNull InputStream $this$sha1) {
        Intrinsics.checkNotNullParameter((Object)$this$sha1, (String)"<this>");
        MessageDigest messageDigest = MessageDigest.getInstance(SHA_1);
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(...)");
        return this.hash(messageDigest, $this$sha1);
    }

    @NotNull
    public final String sha1(@NotNull byte[] $this$sha1) {
        Intrinsics.checkNotNullParameter((Object)$this$sha1, (String)"<this>");
        return this.sha1(new ByteArrayInputStream($this$sha1));
    }

    @NotNull
    public final String sha256(@NotNull InputStream $this$sha256) {
        Intrinsics.checkNotNullParameter((Object)$this$sha256, (String)"<this>");
        MessageDigest messageDigest = MessageDigest.getInstance(SHA_256);
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(...)");
        return this.hash(messageDigest, $this$sha256);
    }

    @NotNull
    public final String sha256(@NotNull byte[] $this$sha256) {
        Intrinsics.checkNotNullParameter((Object)$this$sha256, (String)"<this>");
        return this.sha256(new ByteArrayInputStream($this$sha256));
    }

    @NotNull
    public final String sha512(@NotNull InputStream $this$sha512) {
        Intrinsics.checkNotNullParameter((Object)$this$sha512, (String)"<this>");
        MessageDigest messageDigest = MessageDigest.getInstance(SHA_512);
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(...)");
        return this.hash(messageDigest, $this$sha512);
    }

    @NotNull
    public final String sha512(@NotNull byte[] $this$sha512) {
        Intrinsics.checkNotNullParameter((Object)$this$sha512, (String)"<this>");
        return this.sha512(new ByteArrayInputStream($this$sha512));
    }

    public final long murmur64(long $this$murmur64) {
        long value = $this$murmur64;
        value ^= value >>> 33;
        value *= -49064778989728563L;
        value ^= value >>> 33;
        value *= -4265267296055464877L;
        value ^= value >>> 33;
        return value;
    }
}

