/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.observer.set;

import de.bixilon.kutil.observer.set.SetChange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Spliterator;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlin.jvm.internal.markers.KMutableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010)\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u00012B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0013\u001a\u00020\n2\u0018\u0010\u0014\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t\u0012\u0004\u0012\u00020\n0\bJ\u0016\u0010\u0015\u001a\u00020\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0002J\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0016\u0010\u001b\u001a\u00020\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001dH\u0016J\b\u0010\u001e\u001a\u00020\nH\u0016J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000 H\u0096\u0002J\u0015\u0010!\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0016\u0010\"\u001a\u00020\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001dH\u0016J\u0016\u0010#\u001a\u00020\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001dH\u0016J\u0016\u0010$\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0016\u0010%\u001a\u00020\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001dH\u0016J\b\u0010&\u001a\u00020\u0018H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\fH\u0016J\u0013\u0010*\u001a\u00020\u00182\b\u0010+\u001a\u0004\u0018\u00010,H\u0096\u0002J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000.H\u0016J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00028\u000000H\u0016J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00028\u000000H\u0016R&\u0010\u0006\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t\u0012\u0004\u0012\u00020\n0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR0\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0005\u00a8\u00063"}, d2={"Lde/bixilon/kutil/observer/set/ObservedSet;", "V", "", "unsafe", "<init>", "(Ljava/util/Set;)V", "observers", "", "Lkotlin/Function1;", "Lde/bixilon/kutil/observer/set/SetChange;", "", "size", "", "getSize", "()I", "value", "getUnsafe", "()Ljava/util/Set;", "setUnsafe", "addObserver", "observer", "notifyObservers", "change", "add", "", "element", "(Ljava/lang/Object;)Z", "addAll", "elements", "", "clear", "iterator", "", "remove", "removeAll", "retainAll", "contains", "containsAll", "isEmpty", "toString", "", "hashCode", "equals", "other", "", "spliterator", "Ljava/util/Spliterator;", "parallelStream", "Ljava/util/stream/Stream;", "stream", "SetIterator", "kutil"})
public final class ObservedSet<V>
implements Set<V>,
KMutableSet {
    @NotNull
    private final List<Function1<SetChange<V>, Unit>> observers;
    @NotNull
    private Set<V> unsafe;

    public ObservedSet(@NotNull Set<V> unsafe) {
        Intrinsics.checkNotNullParameter(unsafe, (String)"unsafe");
        this.observers = new ArrayList();
        this.unsafe = unsafe;
    }

    public int getSize() {
        return this.unsafe.size();
    }

    @NotNull
    public final Set<V> getUnsafe() {
        return this.unsafe;
    }

    public final void setUnsafe(@NotNull Set<V> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (Intrinsics.areEqual(this.unsafe, value)) {
            return;
        }
        Set<V> previous = this.unsafe;
        this.unsafe = value;
        this.notifyObservers(new SetChange((Collection)value, (Collection)previous));
    }

    public final void addObserver(@NotNull Function1<? super SetChange<V>, Unit> observer) {
        Intrinsics.checkNotNullParameter(observer, (String)"observer");
        ((Collection)this.observers).add(observer);
    }

    private final void notifyObservers(SetChange<V> change) {
        for (Function1<SetChange<V>, Unit> observer : this.observers) {
            observer.invoke(change);
        }
    }

    @Override
    public boolean add(V element) {
        boolean added = this.unsafe.add(element);
        if (!added) {
            return false;
        }
        this.notifyObservers(new SetChange(SetsKt.setOf(element), SetsKt.emptySet()));
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends V> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean add = this.unsafe.addAll(elements);
        if (!add) {
            return false;
        }
        this.notifyObservers(new SetChange<V>(elements, SetsKt.emptySet()));
        return true;
    }

    @Override
    public void clear() {
        Set copy = CollectionsKt.toSet((Iterable)this.unsafe);
        this.unsafe.clear();
        this.notifyObservers(new SetChange(SetsKt.emptySet(), copy));
    }

    @Override
    @NotNull
    public Iterator<V> iterator() {
        return new SetIterator(this.unsafe.iterator());
    }

    @Override
    public boolean remove(Object element) {
        boolean removed = this.unsafe.remove(element);
        if (!removed) {
            return false;
        }
        this.notifyObservers(new SetChange(SetsKt.emptySet(), SetsKt.setOf((Object)element)));
        return true;
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean removed = this.unsafe.removeAll(elements);
        if (!removed) {
            return false;
        }
        this.notifyObservers(new SetChange<Object>(SetsKt.emptySet(), elements));
        return true;
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean retained = this.unsafe.retainAll(elements);
        if (!retained) {
            return false;
        }
        System.out.println((Object)"Kutil: Set::retainAll is not observed yet!");
        return true;
    }

    @Override
    public boolean contains(Object element) {
        return this.unsafe.contains(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.unsafe.containsAll(elements);
    }

    @Override
    public boolean isEmpty() {
        return this.unsafe.isEmpty();
    }

    @NotNull
    public String toString() {
        return this.unsafe.toString();
    }

    @Override
    public int hashCode() {
        return ((Object)this.unsafe).hashCode();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return Intrinsics.areEqual(this.unsafe, (Object)other);
    }

    @Override
    @NotNull
    public Spliterator<V> spliterator() {
        Spliterator<V> spliterator = this.unsafe.spliterator();
        Intrinsics.checkNotNullExpressionValue(spliterator, (String)"spliterator(...)");
        return spliterator;
    }

    @Override
    @NotNull
    public Stream<V> parallelStream() {
        Stream stream = this.unsafe.parallelStream();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"parallelStream(...)");
        return stream;
    }

    @Override
    @NotNull
    public Stream<V> stream() {
        Stream stream = this.unsafe.stream();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"stream(...)");
        return stream;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010)\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\t\u0010\t\u001a\u00020\nH\u0096\u0002J\u000e\u0010\u000b\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\fR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\r"}, d2={"Lde/bixilon/kutil/observer/set/ObservedSet$SetIterator;", "", "iterator", "<init>", "(Lde/bixilon/kutil/observer/set/ObservedSet;Ljava/util/Iterator;)V", "current", "Ljava/lang/Object;", "remove", "", "hasNext", "", "next", "()Ljava/lang/Object;", "kutil"})
    private final class SetIterator
    implements Iterator<V>,
    KMutableIterator {
        @NotNull
        private final Iterator<V> iterator;
        @Nullable
        private V current;

        public SetIterator(Iterator<? extends V> iterator) {
            Intrinsics.checkNotNullParameter(iterator, (String)"iterator");
            this.iterator = iterator;
        }

        @Override
        public void remove() {
            Object v = this.current;
            if (v == null) {
                throw new IllegalStateException("Not iterating!");
            }
            Object current = v;
            this.iterator.remove();
            ObservedSet.this.notifyObservers(new SetChange(SetsKt.emptySet(), SetsKt.setOf(current)));
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            Object value = this.iterator.next();
            this.current = value;
            return value;
        }
    }
}

