/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.reflection.wrapper.unsafe;

import de.bixilon.kutil.reflection.wrapper.StaticField;
import de.bixilon.kutil.unsafe.UnsafeUtil;
import java.lang.reflect.Field;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\rH\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\u0012\u0010&\u001a\u00020\u00132\b\u0010'\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u0018H\u0016J\u0010\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u001aH\u0016J\u0010\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u001cH\u0016J\u0010\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u001eH\u0016J\u0010\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020 H\u0016J\u0010\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\rH\u0016J\u0010\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020#H\u0016J\u0010\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020%H\u0016J\b\u0010*\u001a\u00020\u0015H\u0016J\b\u0010+\u001a\u00020 H\u0016J\u0013\u0010,\u001a\u00020\u00182\b\u0010-\u001a\u0004\u0018\u00010\tH\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006."}, d2={"Lde/bixilon/kutil/reflection/wrapper/unsafe/UnsafeStaticField;", "Lde/bixilon/kutil/reflection/wrapper/StaticField;", "field", "Ljava/lang/reflect/Field;", "<init>", "(Ljava/lang/reflect/Field;)V", "getField", "()Ljava/lang/reflect/Field;", "base", "", "kotlin.jvm.PlatformType", "Ljava/lang/Object;", "offset", "", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "requireType", "", "name", "", "getAny", "getBoolean", "", "getByte", "", "getShort", "", "getChar", "", "getInt", "", "getLong", "getFloat", "", "getDouble", "", "set", "value", "getName", "()Ljava/lang/String;", "toString", "hashCode", "equals", "other", "kutil"})
public final class UnsafeStaticField
implements StaticField {
    @NotNull
    private final Field field;
    private final Object base;
    private final long offset;

    public UnsafeStaticField(@NotNull Field field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        this.field = field;
        this.base = UnsafeUtil.INSTANCE.getUNSAFE().staticFieldBase(this.field);
        this.offset = UnsafeUtil.INSTANCE.getUNSAFE().staticFieldOffset(this.field);
    }

    @NotNull
    public final Field getField() {
        return this.field;
    }

    @Override
    @NotNull
    public Class<?> getType() {
        Class<?> clazz = this.field.getType();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"getType(...)");
        return clazz;
    }

    private final void requireType(String name) {
        if (!Intrinsics.areEqual((Object)name, (Object)this.getType().getName())) {
            throw new IllegalArgumentException("Can not set " + this.getType().getName() + " field to an " + name);
        }
    }

    @Override
    @Nullable
    public Object getAny() {
        return UnsafeUtil.INSTANCE.getUNSAFE().getObject(this.base, this.offset);
    }

    @Override
    public boolean getBoolean() {
        this.requireType("boolean");
        return UnsafeUtil.INSTANCE.getUNSAFE().getBoolean(this.base, this.offset);
    }

    @Override
    public byte getByte() {
        this.requireType("byte");
        return UnsafeUtil.INSTANCE.getUNSAFE().getByte(this.base, this.offset);
    }

    @Override
    public short getShort() {
        this.requireType("short");
        return UnsafeUtil.INSTANCE.getUNSAFE().getShort(this.base, this.offset);
    }

    @Override
    public char getChar() {
        this.requireType("char");
        return UnsafeUtil.INSTANCE.getUNSAFE().getChar(this.base, this.offset);
    }

    @Override
    public int getInt() {
        this.requireType("int");
        return UnsafeUtil.INSTANCE.getUNSAFE().getInt(this.base, this.offset);
    }

    @Override
    public long getLong() {
        this.requireType("long");
        return UnsafeUtil.INSTANCE.getUNSAFE().getLong(this.base, this.offset);
    }

    @Override
    public float getFloat() {
        this.requireType("float");
        return UnsafeUtil.INSTANCE.getUNSAFE().getFloat(this.base, this.offset);
    }

    @Override
    public double getDouble() {
        this.requireType("double");
        return UnsafeUtil.INSTANCE.getUNSAFE().getDouble(this.base, this.offset);
    }

    @Override
    public void set(@Nullable Object value) {
        if (value != null && !this.field.getType().isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException(value.getClass() + " is not assignable to " + this.field.getType());
        }
        UnsafeUtil.INSTANCE.getUNSAFE().putObject(this.base, this.offset, value);
    }

    @Override
    public void set(boolean value) {
        this.requireType("boolean");
        UnsafeUtil.INSTANCE.getUNSAFE().putBoolean(this.base, this.offset, value);
    }

    @Override
    public void set(byte value) {
        this.requireType("byte");
        UnsafeUtil.INSTANCE.getUNSAFE().putByte(this.base, this.offset, value);
    }

    @Override
    public void set(short value) {
        this.requireType("short");
        UnsafeUtil.INSTANCE.getUNSAFE().putShort(this.base, this.offset, value);
    }

    @Override
    public void set(char value) {
        this.requireType("char");
        UnsafeUtil.INSTANCE.getUNSAFE().putChar(this.base, this.offset, value);
    }

    @Override
    public void set(int value) {
        this.requireType("int");
        UnsafeUtil.INSTANCE.getUNSAFE().putInt(this.base, this.offset, value);
    }

    @Override
    public void set(long value) {
        this.requireType("long");
        UnsafeUtil.INSTANCE.getUNSAFE().putLong(this.base, this.offset, value);
    }

    @Override
    public void set(float value) {
        this.requireType("float");
        UnsafeUtil.INSTANCE.getUNSAFE().putFloat(this.base, this.offset, value);
    }

    @Override
    public void set(double value) {
        this.requireType("double");
        UnsafeUtil.INSTANCE.getUNSAFE().putDouble(this.base, this.offset, value);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.field.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    public String toString() {
        String string = this.field.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public int hashCode() {
        return this.base.hashCode() + (int)this.offset;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof UnsafeStaticField)) {
            return false;
        }
        return ((UnsafeStaticField)other).offset == this.offset && Intrinsics.areEqual((Object)((UnsafeStaticField)other).base, (Object)this.base);
    }

    @Override
    public <T> T get() {
        return StaticField.DefaultImpls.get(this);
    }

    @Override
    public void setPrimitive(@NotNull Object value) {
        StaticField.DefaultImpls.setPrimitive(this, value);
    }
}

