/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.stream;

import de.bixilon.kutil.buffer.ByteBufferUtil;
import de.bixilon.kutil.exception.ExceptionUtil;
import de.bixilon.kutil.string.StringUtil;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.Signature;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bJ\u001e\u0010\t\u001a\u00020\n*\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0007\u001a\u00020\bJ\u0012\u0010\r\u001a\u00020\u000e*\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010JO\u0010\r\u001a\u00020\u0011*\u00020\u00062\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0012\"\u00020\u00102\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\b\u0002\u0010\u0017\u001a\u00020\b2\b\b\u0002\u0010\u0018\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lde/bixilon/kutil/stream/InputStreamUtil;", "", "<init>", "()V", "readAll", "", "Ljava/io/InputStream;", "close", "", "readAsString", "", "charset", "Ljava/nio/charset/Charset;", "copy", "", "output", "Ljava/io/OutputStream;", "", "", "digest", "Ljava/security/MessageDigest;", "signature", "Ljava/security/Signature;", "closeIn", "closeOut", "(Ljava/io/InputStream;[Ljava/io/OutputStream;Ljava/security/MessageDigest;Ljava/security/Signature;ZZ)V", "kutil"})
@SourceDebugExtension(value={"SMAP\nInputStreamUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InputStreamUtil.kt\nde/bixilon/kutil/stream/InputStreamUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ExceptionUtil.kt\nde/bixilon/kutil/exception/ExceptionUtil\n*L\n1#1,77:1\n1#2:78\n56#3,6:79\n56#3,6:85\n56#3,6:91\n*S KotlinDebug\n*F\n+ 1 InputStreamUtil.kt\nde/bixilon/kutil/stream/InputStreamUtil\n*L\n34#1:79,6\n69#1:85,6\n72#1:91,6\n*E\n"})
public final class InputStreamUtil {
    @NotNull
    public static final InputStreamUtil INSTANCE = new InputStreamUtil();

    private InputStreamUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] readAll(@NotNull InputStream $this$readAll, boolean close) {
        Intrinsics.checkNotNullParameter((Object)$this$readAll, (String)"<this>");
        if (close) {
            byte[] byArray;
            Closeable closeable = $this$readAll;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                byArray = $this$readAll.readAllBytes();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"use(...)");
            return byArray;
        }
        byte[] byArray = $this$readAll.readAllBytes();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
        return byArray;
    }

    public static /* synthetic */ byte[] readAll$default(InputStreamUtil inputStreamUtil, InputStream inputStream, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return inputStreamUtil.readAll(inputStream, bl);
    }

    @NotNull
    public final String readAsString(@NotNull InputStream $this$readAsString, @NotNull Charset charset, boolean close) {
        Intrinsics.checkNotNullParameter((Object)$this$readAsString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        String string = new String(InputStreamUtil.readAll$default(this, $this$readAsString, false, 1, null), charset);
        if (close) {
            ExceptionUtil this_$iv = ExceptionUtil.INSTANCE;
            boolean $i$f$ignoreAll = false;
            try {
                boolean bl = false;
                $this$readAsString.close();
            }
            catch (Throwable error$iv) {
                error$iv.printStackTrace();
            }
        }
        return string;
    }

    public static /* synthetic */ String readAsString$default(InputStreamUtil inputStreamUtil, InputStream inputStream, Charset charset, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            charset = StringUtil.INSTANCE.getDEFAULT_CHARSET();
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return inputStreamUtil.readAsString(inputStream, charset, bl);
    }

    public final long copy(@NotNull InputStream $this$copy, @NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)$this$copy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        byte[] buffer = ByteBufferUtil.createBuffer$default(ByteBufferUtil.INSTANCE, 0, 1, null);
        int length = 0;
        long size = 0L;
        while ((length = $this$copy.read(buffer, 0, buffer.length)) >= 0) {
            size += (long)length;
            output.write(buffer, 0, length);
        }
        return size;
    }

    public final void copy(@NotNull InputStream $this$copy, @NotNull OutputStream[] output, @Nullable MessageDigest digest, @Nullable Signature signature, boolean closeIn, boolean closeOut) {
        int length;
        Intrinsics.checkNotNullParameter((Object)$this$copy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        byte[] buffer = ByteBufferUtil.createBuffer$default(ByteBufferUtil.INSTANCE, 0, 1, null);
        while ((length = $this$copy.read(buffer, 0, buffer.length)) >= 0) {
            for (OutputStream stream : output) {
                stream.write(buffer, 0, length);
            }
            MessageDigest messageDigest = digest;
            if (messageDigest != null) {
                messageDigest.update(buffer, 0, length);
            }
            Signature signature2 = signature;
            if (signature2 == null) continue;
            signature2.update(buffer, 0, length);
        }
        if (closeIn) {
            ExceptionUtil this_$iv = ExceptionUtil.INSTANCE;
            boolean $i$f$ignoreAll = false;
            try {
                boolean bl = false;
                $this$copy.close();
            }
            catch (Throwable error$iv) {
                error$iv.printStackTrace();
            }
        }
        if (closeOut) {
            for (OutputStream stream : output) {
                ExceptionUtil this_$iv = ExceptionUtil.INSTANCE;
                boolean $i$f$ignoreAll = false;
                try {
                    boolean bl = false;
                    stream.close();
                }
                catch (Throwable error$iv) {
                    error$iv.printStackTrace();
                }
            }
        }
    }

    public static /* synthetic */ void copy$default(InputStreamUtil inputStreamUtil, InputStream inputStream, OutputStream[] outputStreamArray, MessageDigest messageDigest, Signature signature, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            messageDigest = null;
        }
        if ((n & 4) != 0) {
            signature = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        inputStreamUtil.copy(inputStream, outputStreamArray, messageDigest, signature, bl, bl2);
    }
}

