/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.string;

import de.bixilon.kutil.cast.CastUtil;
import de.bixilon.kutil.reflection.ReflectionUtil;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.PrimitiveIterator;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0011J\n\u0010\u0012\u001a\u00020\u0011*\u00020\u0011J\n\u0010\u0013\u001a\u00020\u0014*\u00020\u0011J\n\u0010\u0015\u001a\u00020\u0014*\u00020\u0011J\u001e\u0010\u0016\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u0002J \u0010\u0016\u001a\u00020\u0011*\u00020\u00112\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001aJ?\u0010\u0016\u001a\u00020\u0011*\u00020\u00112.\u0010\u0019\u001a\u0018\u0012\u0014\b\u0001\u0012\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001c0\u001b\"\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001c\u00a2\u0006\u0002\u0010\u001dJ\u001a\u0010\u001e\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0011J\u0019\u0010!\u001a\u0004\u0018\u00010\"*\u00020\u00112\u0006\u0010#\u001a\u00020\"\u00a2\u0006\u0002\u0010$J\u0012\u0010%\u001a\u00020\u0011*\u00020\u00112\u0006\u0010&\u001a\u00020\"J\u001a\u0010'\u001a\u00020\u0011*\u00020\u00112\u0006\u0010(\u001a\u00020)2\u0006\u0010&\u001a\u00020\"J\f\u0010*\u001a\u00020+*\u00020\u0011H\u0007R\u001d\u0010\u0004\u001a\u0004\u0018\u00010\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006,"}, d2={"Lde/bixilon/kutil/string/StringUtil;", "", "<init>", "()V", "VALUE", "Ljava/lang/reflect/Field;", "getVALUE", "()Ljava/lang/reflect/Field;", "VALUE$delegate", "Lkotlin/Lazy;", "DEFAULT_CHARSET", "Ljava/nio/charset/Charset;", "kotlin.jvm.PlatformType", "getDEFAULT_CHARSET", "()Ljava/nio/charset/Charset;", "Ljava/nio/charset/Charset;", "toSnakeCase", "", "toCamelCase", "isLowercase", "", "isUppercase", "formatPlaceholder", "key", "value", "format", "", "", "Lkotlin/Pair;", "(Ljava/lang/String;[Lkotlin/Pair;)Ljava/lang/String;", "getBetween", "first", "second", "codePointAtOrNull", "", "index", "(Ljava/lang/String;I)Ljava/lang/Integer;", "truncate", "length", "fill", "char", "", "mutable", "", "kutil"})
@SourceDebugExtension(value={"SMAP\nStringUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringUtil.kt\nde/bixilon/kutil/string/StringUtil\n+ 2 CastUtil.kt\nde/bixilon/kutil/cast/CastUtil\n*L\n1#1,141:1\n18#2:142\n*S KotlinDebug\n*F\n+ 1 StringUtil.kt\nde/bixilon/kutil/string/StringUtil\n*L\n138#1:142\n*E\n"})
public final class StringUtil {
    @NotNull
    public static final StringUtil INSTANCE = new StringUtil();
    @NotNull
    private static final Lazy VALUE$delegate = LazyKt.lazy(StringUtil::VALUE_delegate$lambda$0);
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;

    private StringUtil() {
    }

    private final Field getVALUE() {
        Lazy lazy = VALUE$delegate;
        return (Field)lazy.getValue();
    }

    public final Charset getDEFAULT_CHARSET() {
        return DEFAULT_CHARSET;
    }

    @NotNull
    public final String toSnakeCase(@NotNull String $this$toSnakeCase) {
        Intrinsics.checkNotNullParameter((Object)$this$toSnakeCase, (String)"<this>");
        if (((CharSequence)$this$toSnakeCase).length() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder($this$toSnakeCase.length());
        PrimitiveIterator.OfInt codes = $this$toSnakeCase.codePoints().iterator();
        int uppercased = 1;
        while (codes.hasNext()) {
            int code = codes.nextInt();
            if (Character.isUpperCase(code)) {
                if (uppercased == 0) {
                    result.append('_');
                }
                ++uppercased;
            } else {
                uppercased = 0;
            }
            result.appendCodePoint(Character.toLowerCase(code));
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String toCamelCase(@NotNull String $this$toCamelCase) {
        Intrinsics.checkNotNullParameter((Object)$this$toCamelCase, (String)"<this>");
        if (((CharSequence)$this$toCamelCase).length() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder($this$toCamelCase.length());
        PrimitiveIterator.OfInt codes = $this$toCamelCase.codePoints().iterator();
        boolean underscore = false;
        while (codes.hasNext()) {
            int code = Character.toLowerCase(codes.nextInt());
            if (code == 95) {
                underscore = true;
                continue;
            }
            if (underscore) {
                result.appendCodePoint(Character.toUpperCase(code));
                underscore = false;
                continue;
            }
            result.appendCodePoint(code);
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final boolean isLowercase(@NotNull String $this$isLowercase) {
        Intrinsics.checkNotNullParameter((Object)$this$isLowercase, (String)"<this>");
        PrimitiveIterator.OfInt ofInt = $this$isLowercase.codePoints().iterator();
        while (ofInt.hasNext()) {
            Integer code = ofInt.next();
            Intrinsics.checkNotNull((Object)code);
            if (!Character.isUpperCase(code)) continue;
            return false;
        }
        return true;
    }

    public final boolean isUppercase(@NotNull String $this$isUppercase) {
        Intrinsics.checkNotNullParameter((Object)$this$isUppercase, (String)"<this>");
        PrimitiveIterator.OfInt ofInt = $this$isUppercase.codePoints().iterator();
        while (ofInt.hasNext()) {
            Integer code = ofInt.next();
            Intrinsics.checkNotNull((Object)code);
            if (!Character.isLowerCase(code)) continue;
            return false;
        }
        return true;
    }

    private final String formatPlaceholder(String $this$formatPlaceholder, String key, Object value) {
        return StringsKt.replace$default((String)$this$formatPlaceholder, (String)("${" + key + '}'), (String)String.valueOf(value), (boolean)false, (int)4, null);
    }

    @NotNull
    public final String formatPlaceholder(@NotNull String $this$formatPlaceholder, @NotNull Map<String, ? extends Object> format) {
        Intrinsics.checkNotNullParameter((Object)$this$formatPlaceholder, (String)"<this>");
        Intrinsics.checkNotNullParameter(format, (String)"format");
        String output = $this$formatPlaceholder;
        for (Map.Entry<String, ? extends Object> entry : format.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            output = this.formatPlaceholder(output, key, value);
        }
        return output;
    }

    @NotNull
    public final String formatPlaceholder(@NotNull String $this$formatPlaceholder, Pair<String, ? extends Object> ... format) {
        Intrinsics.checkNotNullParameter((Object)$this$formatPlaceholder, (String)"<this>");
        Intrinsics.checkNotNullParameter(format, (String)"format");
        String output = $this$formatPlaceholder;
        for (Pair<String, ? extends Object> pair : format) {
            String key = (String)pair.component1();
            Object value = pair.component2();
            output = this.formatPlaceholder(output, key, value);
        }
        return output;
    }

    @NotNull
    public final String getBetween(@NotNull String $this$getBetween, @NotNull String first, @NotNull String second) {
        Intrinsics.checkNotNullParameter((Object)$this$getBetween, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        String string = $this$getBetween.substring(StringsKt.indexOf$default((CharSequence)$this$getBetween, (String)first, (int)0, (boolean)false, (int)6, null) + first.length());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String result = string;
        String string2 = result.substring(0, StringsKt.indexOf$default((CharSequence)result, (String)second, (int)0, (boolean)false, (int)6, null));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return string2;
    }

    @Nullable
    public final Integer codePointAtOrNull(@NotNull String $this$codePointAtOrNull, int index) {
        Intrinsics.checkNotNullParameter((Object)$this$codePointAtOrNull, (String)"<this>");
        if (index < 0 || index >= $this$codePointAtOrNull.length()) {
            return null;
        }
        return $this$codePointAtOrNull.codePointAt(index);
    }

    @NotNull
    public final String truncate(@NotNull String $this$truncate, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$truncate, (String)"<this>");
        if (length < 0) {
            throw new IllegalArgumentException("Length must not be < 0: " + length);
        }
        if ($this$truncate.length() <= length) {
            return $this$truncate;
        }
        String string = $this$truncate.substring(0, length);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    @NotNull
    public final String fill(@NotNull String $this$fill, char c, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$fill, (String)"<this>");
        if ($this$fill.length() >= length) {
            return $this$fill;
        }
        String fill = StringsKt.repeat((CharSequence)String.valueOf(c), (int)(length - $this$fill.length()));
        return fill + $this$fill;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="fucking unsafe")
    @NotNull
    public final byte[] mutable(@NotNull String $this$mutable) {
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)$this$mutable, (String)"<this>");
        CastUtil castUtil = CastUtil.INSTANCE;
        Field field = this.getVALUE();
        Intrinsics.checkNotNull((Object)field);
        Object $this$unsafeCast$iv = field.get($this$mutable);
        boolean $i$f$unsafeCast = false;
        return (byte[])var3_3;
    }

    private static final Field VALUE_delegate$lambda$0() {
        return ReflectionUtil.getFieldOrNull$default(ReflectionUtil.INSTANCE, String.class, "value", false, 2, null);
    }
}

