/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.jsqlserverbulkinsert;

import com.microsoft.sqlserver.jdbc.SQLServerBulkCopy;
import com.microsoft.sqlserver.jdbc.SQLServerBulkCopyOptions;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import de.bytefish.jsqlserverbulkinsert.ISqlServerBulkInsert;
import de.bytefish.jsqlserverbulkinsert.mapping.AbstractMapping;
import de.bytefish.jsqlserverbulkinsert.model.IColumnDefinition;
import de.bytefish.jsqlserverbulkinsert.records.SqlServerBulkData;
import de.bytefish.jsqlserverbulkinsert.util.SchemaUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;

public class SqlServerBulkInsert<TEntity>
implements ISqlServerBulkInsert<TEntity> {
    private final AbstractMapping<TEntity> mapping;

    public SqlServerBulkInsert(AbstractMapping<TEntity> mapping) {
        this.mapping = mapping;
    }

    @Override
    public void saveAll(Connection connection, Stream<TEntity> entities) {
        this.saveAll(connection, new SQLServerBulkCopyOptions(), entities);
    }

    public void saveAll(Connection connection, SQLServerBulkCopyOptions options, Stream<TEntity> entities) {
        SchemaUtils.validateColumnMapping(connection, this.mapping);
        try (SQLServerBulkCopy sqlServerBulkCopy = new SQLServerBulkCopy(connection);){
            sqlServerBulkCopy.setBulkCopyOptions(options);
            sqlServerBulkCopy.setDestinationTableName(this.mapping.getTableDefinition().GetFullQualifiedTableName());
            List<IColumnDefinition<TEntity>> columnMappings = SchemaUtils.getSortedColumnMappings(connection, this.mapping);
            SqlServerBulkData<TEntity> record = new SqlServerBulkData<TEntity>(columnMappings, entities.iterator());
            sqlServerBulkCopy.writeToServer(record);
        }
        catch (SQLServerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void saveAll(Connection connection, Collection<TEntity> entities) throws SQLException {
        if (entities == null) {
            throw new IllegalArgumentException("entities");
        }
        this.saveAll(connection, entities.stream());
    }
}

