/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.jsqlserverbulkinsert.converters;

import de.bytefish.jsqlserverbulkinsert.converters.BaseConverter;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public class LocalDateTimeConverter
extends BaseConverter<LocalDateTime> {
    static ZoneOffset zoneOffset = OffsetDateTime.now().getOffset();

    @Override
    public Object internalConvert(LocalDateTime value) {
        long epochSeconds = value.toEpochSecond(zoneOffset);
        Timestamp castedResult = new Timestamp(epochSeconds * 1000L);
        castedResult.setNanos(value.getNano() / 100 * 100);
        return castedResult;
    }
}

