/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.jsqlserverbulkinsert.extensions;

import de.bytefish.jsqlserverbulkinsert.converters.BaseConverter;
import de.bytefish.jsqlserverbulkinsert.mapping.AbstractMapping;
import de.bytefish.jsqlserverbulkinsert.util.TimestampUtils;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractMap;
import java.util.function.Function;

public class DateTimeExtensions {
    public static <TEntity> void mapUTCNano(AbstractMapping<TEntity> mapping, String dateColumnName, String timeColumnName, Function<TEntity, Long> propertyGetter) {
        mapping.mapProperty(dateColumnName, 91, propertyGetter, new BaseConverter<Long>(){

            @Override
            public Object internalConvert(Long value) {
                AbstractMap.SimpleImmutableEntry<Long, Integer> convertedDT = TimestampUtils.convertUtcNanoToEpochSecAndNano(value);
                return new Date(convertedDT.getKey() * 1000L);
            }
        });
        mapping.mapProperty(timeColumnName, 92, propertyGetter, new BaseConverter<Long>(){

            @Override
            public Object internalConvert(Long value) {
                AbstractMap.SimpleImmutableEntry<Long, Integer> convertedDT = TimestampUtils.convertUtcNanoToEpochSecAndNano(value);
                Time t = new Time(convertedDT.getKey() * 1000L);
                return t.toString() + "." + convertedDT.getValue() / 100;
            }
        });
    }

    public static <TEntity> void mapUTCNano(AbstractMapping<TEntity> mapping, String columnName, Function<TEntity, Long> propertyGetter) {
        mapping.mapProperty(columnName, 93, propertyGetter, new BaseConverter<Long>(){

            @Override
            public Object internalConvert(Long value) {
                AbstractMap.SimpleImmutableEntry<Long, Integer> convertedDT = TimestampUtils.convertUtcNanoToEpochSecAndNano(value);
                Timestamp castedResult = new Timestamp(convertedDT.getKey() * 1000L);
                castedResult.setNanos(convertedDT.getValue());
                return castedResult;
            }
        });
    }
}

