/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.jsqlserverbulkinsert.mapping;

import de.bytefish.jsqlserverbulkinsert.converters.BigDecimalConverter;
import de.bytefish.jsqlserverbulkinsert.converters.BigIntegerConverter;
import de.bytefish.jsqlserverbulkinsert.converters.IConverter;
import de.bytefish.jsqlserverbulkinsert.converters.IdentityConverter;
import de.bytefish.jsqlserverbulkinsert.converters.InstantConverter;
import de.bytefish.jsqlserverbulkinsert.converters.LocalDateTimeConverter;
import de.bytefish.jsqlserverbulkinsert.converters.NullConverter;
import de.bytefish.jsqlserverbulkinsert.functional.ToBooleanFunction;
import de.bytefish.jsqlserverbulkinsert.functional.ToFloatFunction;
import de.bytefish.jsqlserverbulkinsert.model.ColumnDefinition;
import de.bytefish.jsqlserverbulkinsert.model.ColumnMetaData;
import de.bytefish.jsqlserverbulkinsert.model.IColumnDefinition;
import de.bytefish.jsqlserverbulkinsert.model.TableDefinition;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public abstract class AbstractMapping<TEntity> {
    private TableDefinition table;
    private List<IColumnDefinition<TEntity>> columns;

    public AbstractMapping(String tableName) {
        this("", tableName);
    }

    public AbstractMapping(String schemaName, String tableName) {
        this.table = new TableDefinition(schemaName, tableName);
        this.columns = new ArrayList<IColumnDefinition<TEntity>>();
    }

    protected void mapBoolean(String columnName, Function<TEntity, Boolean> propertyGetter) {
        this.mapProperty(columnName, -7, propertyGetter, new IdentityConverter());
    }

    protected void mapBooleanPrimitive(String columnName, ToBooleanFunction<TEntity> propertyGetter) {
        this.mapProperty(columnName, -7, entity -> propertyGetter.applyAsBoolean(entity), new IdentityConverter());
    }

    protected void mapChar(String columnName, Function<TEntity, Character> propertyGetter) {
        this.mapProperty(columnName, 1, propertyGetter, new IdentityConverter());
    }

    protected void mapNchar(String columnName, Function<TEntity, Character> propertyGetter) {
        this.mapProperty(columnName, -15, propertyGetter, new IdentityConverter());
    }

    protected void mapClob(String columnName, Function<TEntity, Character> propertyGetter) {
        this.mapProperty(columnName, 2005, propertyGetter, new IdentityConverter());
    }

    protected void mapVarchar(String columnName, Function<TEntity, String> propertyGetter) {
        this.mapProperty(columnName, 12, propertyGetter, new IdentityConverter());
    }

    protected void mapLongVarchar(String columnName, Function<TEntity, Character> propertyGetter) {
        this.mapProperty(columnName, -1, propertyGetter, new IdentityConverter());
    }

    protected void mapNvarchar(String columnName, Function<TEntity, String> propertyGetter) {
        this.mapProperty(columnName, -9, propertyGetter, new IdentityConverter());
    }

    protected void mapLongNvarchar(String columnName, Function<TEntity, Character> propertyGetter) {
        this.mapProperty(columnName, -16, propertyGetter, new IdentityConverter());
    }

    protected <TProperty> void mapNull(String columnName, Function<TEntity, TProperty> propertyGetter) {
        this.mapProperty(columnName, 0, propertyGetter, new NullConverter());
    }

    protected void mapTinyInt(String columnName, Function<TEntity, Byte> propertyGetter) {
        this.mapProperty(columnName, -6, propertyGetter, new IdentityConverter());
    }

    protected void mapSmallInt(String columnName, Function<TEntity, Short> propertyGetter) {
        this.mapProperty(columnName, 5, propertyGetter, new IdentityConverter());
    }

    protected void mapSmallInt(String columnName, boolean isAutoIncrement) {
        this.mapProperty(columnName, 5, 0, 0, isAutoIncrement, entity -> null, new IdentityConverter());
    }

    protected void mapInteger(String columnName, Function<TEntity, Integer> propertyGetter) {
        this.mapProperty(columnName, 4, propertyGetter, new IdentityConverter());
    }

    protected void mapInteger(String columnName, boolean isAutoIncrement) {
        this.mapProperty(columnName, 4, 0, 0, isAutoIncrement, entity -> null, new IdentityConverter());
    }

    protected void mapIntegerPrimitive(String columnName, ToIntFunction<TEntity> propertyGetter) {
        this.mapProperty(columnName, 4, entity -> propertyGetter.applyAsInt(entity), new IdentityConverter());
    }

    protected void mapLong(String columnName, Function<TEntity, Long> propertyGetter) {
        this.mapProperty(columnName, -5, propertyGetter, new IdentityConverter());
    }

    protected void mapLong(String columnName, boolean isAutoIncrement) {
        this.mapProperty(columnName, -5, 0, 0, isAutoIncrement, entity -> null, new IdentityConverter());
    }

    protected void mapLongPrimitive(String columnName, ToLongFunction<TEntity> propertyGetter) {
        this.mapProperty(columnName, -5, entity -> propertyGetter.applyAsLong(entity), new IdentityConverter());
    }

    protected void mapNumeric(String columnName, int precision, int scale, Function<TEntity, BigDecimal> propertyGetter) {
        this.mapProperty(columnName, 2, precision, scale, false, propertyGetter, new BigDecimalConverter(scale, RoundingMode.HALF_UP));
    }

    protected void mapNumeric(String columnName, int precision, int scale, RoundingMode roundingMode, Function<TEntity, BigDecimal> propertyGetter) {
        this.mapProperty(columnName, 2, precision, scale, false, propertyGetter, new BigDecimalConverter(scale, roundingMode));
    }

    protected void mapDecimal(String columnName, int precision, int scale, Function<TEntity, BigDecimal> propertyGetter) {
        this.mapProperty(columnName, 3, precision, scale, false, propertyGetter, new BigDecimalConverter(scale, RoundingMode.HALF_UP));
    }

    protected void mapReal(String columnName, Function<TEntity, Float> propertyGetter) {
        this.mapProperty(columnName, 7, propertyGetter, new IdentityConverter());
    }

    protected void mapRealPrimitive(String columnName, ToFloatFunction<TEntity> propertyGetter) {
        this.mapProperty(columnName, 7, entity -> Float.valueOf(propertyGetter.applyAsFloat(entity)), new IdentityConverter());
    }

    protected void mapBigInt(String columnName, Function<TEntity, BigInteger> propertyGetter) {
        this.mapProperty(columnName, -5, propertyGetter, new BigIntegerConverter());
    }

    protected void mapDouble(String columnName, Function<TEntity, Double> propertyGetter) {
        this.mapProperty(columnName, 8, propertyGetter, new IdentityConverter());
    }

    protected void mapDoublePrimitive(String columnName, ToDoubleFunction<TEntity> propertyGetter) {
        this.mapProperty(columnName, 8, entity -> propertyGetter.applyAsDouble(entity), new IdentityConverter());
    }

    protected void mapDate(String columnName, Function<TEntity, LocalDate> propertyGetter) {
        this.mapProperty(columnName, 91, propertyGetter, new IdentityConverter());
    }

    protected void mapInstant(String columnName, Function<TEntity, Instant> propertyGetter) {
        this.mapProperty(columnName, 93, propertyGetter, new InstantConverter());
    }

    protected void mapDateTime(String columnName, Function<TEntity, Timestamp> propertyGetter) {
        this.mapProperty(columnName, 93, propertyGetter, new IdentityConverter());
    }

    protected void mapLocalDateTime(String columnName, Function<TEntity, LocalDateTime> propertyGetter) {
        this.mapProperty(columnName, 93, propertyGetter, new LocalDateTimeConverter());
    }

    protected void mapTimeWithTimeZone(String columnName, Function<TEntity, OffsetTime> propertyGetter) {
        this.mapProperty(columnName, 2013, propertyGetter, new IdentityConverter());
    }

    protected void mapDateTimeWithTimeZone(String columnName, Function<TEntity, OffsetDateTime> propertyGetter) {
        this.mapProperty(columnName, 2014, propertyGetter, new IdentityConverter());
    }

    protected void mapVarBinary(String columnName, int maxLength, Function<TEntity, byte[]> propertyGetter) {
        this.mapProperty(columnName, -3, maxLength, 0, false, propertyGetter, new IdentityConverter());
    }

    public <TProperty> void mapProperty(String name, int type, Function<TEntity, TProperty> propertyGetter, IConverter<TProperty> converter) {
        ColumnMetaData columnMetaData = new ColumnMetaData(name, type);
        this.addColumn(columnMetaData, propertyGetter, converter);
    }

    public <TProperty> void mapProperty(String name, int type, int precision, int scale, boolean isAutoIncrement, Function<TEntity, TProperty> propertyGetter, IConverter<TProperty> converter) {
        ColumnMetaData columnMetaData = new ColumnMetaData(name, type, precision, scale, isAutoIncrement);
        this.addColumn(columnMetaData, propertyGetter, converter);
    }

    public <TProperty> void addColumn(ColumnMetaData columnMetaData, Function<TEntity, TProperty> propertyGetter, IConverter<TProperty> converter) {
        ColumnDefinition<TEntity, TProperty> columnDefinition = new ColumnDefinition<TEntity, TProperty>(columnMetaData, propertyGetter, converter);
        this.columns.add(columnDefinition);
    }

    public TableDefinition getTableDefinition() {
        return this.table;
    }

    public List<IColumnDefinition<TEntity>> getColumns() {
        return this.columns;
    }
}

