/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.jsqlserverbulkinsert.util;

import de.bytefish.jsqlserverbulkinsert.mapping.AbstractMapping;
import de.bytefish.jsqlserverbulkinsert.model.IColumnDefinition;
import de.bytefish.jsqlserverbulkinsert.model.SchemaMetaData;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SchemaUtils {
    public static SchemaMetaData getSchemaMetaData(Connection connection, String schemaName, String tableName) throws Exception {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet rs = databaseMetaData.getColumns(null, schemaName, tableName, null);
        ArrayList<SchemaMetaData.ColumnInformation> columnInformations = new ArrayList<SchemaMetaData.ColumnInformation>();
        while (rs.next()) {
            SchemaMetaData.ColumnInformation columnInformation = new SchemaMetaData.ColumnInformation(rs.getString("COLUMN_NAME"), rs.getInt("ORDINAL_POSITION"));
            columnInformations.add(columnInformation);
        }
        List<SchemaMetaData.ColumnInformation> sortedColumns = columnInformations.stream().sorted(Comparator.comparing(x -> x.getOrdinal())).collect(Collectors.toList());
        return new SchemaMetaData(sortedColumns);
    }

    private static <TEntity> SchemaMetaData internalGetSchemaMetaData(Connection connection, AbstractMapping<TEntity> mapping) {
        try {
            return SchemaUtils.getSchemaMetaData(connection, mapping.getTableDefinition().getSchema(), mapping.getTableDefinition().getTableName());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <TEntity> void validateColumnMapping(Connection connection, AbstractMapping<TEntity> mapping) {
        SchemaMetaData schemaMetaData = SchemaUtils.internalGetSchemaMetaData(connection, mapping);
        if (schemaMetaData == null || schemaMetaData.getColumns() == null || schemaMetaData.getColumns().isEmpty()) {
            return;
        }
        if (mapping.getColumns().size() != schemaMetaData.getColumns().size()) {
            throw new RuntimeException("Destination Table has '" + schemaMetaData.getColumns().size() + "' columns, the Source Mapping has '" + mapping.getColumns().size() + "' columns.");
        }
    }

    public static <TEntity> List<IColumnDefinition<TEntity>> getSortedColumnMappings(Connection connection, AbstractMapping<TEntity> mapping) {
        SchemaMetaData schemaMetaData = SchemaUtils.internalGetSchemaMetaData(connection, mapping);
        if (schemaMetaData == null || schemaMetaData.getColumns() == null || schemaMetaData.getColumns().isEmpty()) {
            return mapping.getColumns();
        }
        Map<String, IColumnDefinition> columnDefinitionLookup = mapping.getColumns().stream().collect(Collectors.toMap(x -> x.getColumnMetaData().getName().toUpperCase(), x -> x));
        ArrayList<IColumnDefinition<TEntity>> sortedColumns = new ArrayList<IColumnDefinition<TEntity>>();
        for (SchemaMetaData.ColumnInformation columnMetaData : schemaMetaData.getColumns()) {
            IColumnDefinition columnDefinition = columnDefinitionLookup.get(columnMetaData.getColumnName().toUpperCase());
            sortedColumns.add(columnDefinition);
        }
        return sortedColumns;
    }
}

