/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.db;

import de.chandre.admintool.core.AbstractAdminToolLoader;
import de.chandre.admintool.core.AdminTool;
import de.chandre.admintool.core.component.AdminComponent;
import de.chandre.admintool.core.component.AdminComponentImpl;
import de.chandre.admintool.core.component.MenuEntry;
import de.chandre.admintool.db.AdminToolDBBrowserConfig;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AdminToolDBBrowserLoader
extends AbstractAdminToolLoader {
    private static final Log LOGGER = LogFactory.getLog(AdminToolDBBrowserLoader.class);
    @Autowired
    private AdminTool adminTool;
    @Autowired
    private AdminToolDBBrowserConfig dbBroserConfig;

    @PostConstruct
    public void configureAdminTool() {
        if (!this.coreConfig.isEnabled() || !this.dbBroserConfig.isEnabled()) {
            LOGGER.info((Object)"admin tool's database browser deactivated");
            return;
        }
        LOGGER.info((Object)"adding database browser to admin tool");
        boolean relative = !this.shouldCDNsUsed();
        AdminComponentImpl component = new AdminComponentImpl();
        component.setPosition(this.dbBroserConfig.getComponentPosition());
        component.getSecurityRoles().addAll(this.dbBroserConfig.getSecurityRoles());
        component.setDisplayName("DB Browser");
        String adminLtePrefix = this.getAdminLTEPrefixUri();
        component.addAdditionalJS(adminLtePrefix + "plugins/select2/select2.min.js", relative);
        component.addAdditionalCSS(adminLtePrefix + "plugins/select2/select2.min.css", relative);
        String codeMirrorPrefix = this.getWebjarsPrefixUri(this.dbBroserConfig.getCodeMirrorUseBowser()) + "codemirror/" + this.dbBroserConfig.getCodeMirrorVersion() + "/";
        component.addAdditionalJS(codeMirrorPrefix + "lib/codemirror.js", relative);
        component.addAdditionalJS(codeMirrorPrefix + "mode/meta.js", relative);
        component.addAdditionalJS(codeMirrorPrefix + "mode/sql/sql.js", relative);
        if (null != this.dbBroserConfig.getCodeMirrorAddLibs()) {
            this.dbBroserConfig.getCodeMirrorAddLibs().forEach(arg_0 -> AdminToolDBBrowserLoader.lambda$configureAdminTool$0((AdminComponent)component, codeMirrorPrefix, relative, arg_0));
        }
        component.addAdditionalJS(codeMirrorPrefix + "addon/mode/loadmode.js", relative);
        component.addAdditionalJS(codeMirrorPrefix + "addon/hint/show-hint.js", relative);
        component.addAdditionalJS(codeMirrorPrefix + "addon/hint/sql-hint.js", relative);
        component.addAdditionalCSS(codeMirrorPrefix + "lib/codemirror.css", relative);
        component.addAdditionalCSS(codeMirrorPrefix + "addon/hint/show-hint.css", relative);
        component.addAdditionalJS("/static/admintool/dbbrowser/js/dbbrowser.js", true);
        component.addAdditionalCSS("/static/admintool/dbbrowser/css/dbbrowser.css", true);
        MenuEntry mainMenu = new MenuEntry();
        mainMenu.setDisplayName("DB Browser");
        mainMenu.setName("dbbrowser");
        mainMenu.setTarget("dbbrowser/content/dbbrowser");
        mainMenu.setHide(this.dbBroserConfig.isHideMenuItem());
        mainMenu.setResouceMessageKey("ui.admintool.core.dbbrowser.displayName");
        component.setMainMenu(mainMenu);
        this.adminTool.addComponent((AdminComponent)component);
    }

    private static /* synthetic */ void lambda$configureAdminTool$0(AdminComponent component, String codeMirrorPrefix, boolean relative, String libpath) {
        component.addAdditionalJS(codeMirrorPrefix + libpath, relative);
    }
}

