/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.vaadin.security.spring.access;

import de.codecamp.vaadin.security.spring.access.endpoint.EndpointAccessContext;
import de.codecamp.vaadin.security.spring.access.route.RouteAccessContext;
import java.lang.annotation.Annotation;
import java.util.Optional;

public interface AccessContext {
    public TargetType getTargetType();

    public <A extends Annotation> Optional<A> findAnnotation(Class<A> var1);

    default public boolean isRoute() {
        return this.getTargetType() == TargetType.ROUTE;
    }

    default public RouteAccessContext asRouteAccessContext() {
        if (this.getTargetType() != TargetType.ROUTE) {
            throw new IllegalStateException("This is not a RouteAccessContext.");
        }
        return (RouteAccessContext)this;
    }

    default public boolean isEndpoint() {
        return this.getTargetType() == TargetType.ENDPOINT;
    }

    default public EndpointAccessContext asEndpointAccessContext() {
        if (this.getTargetType() != TargetType.ENDPOINT) {
            throw new IllegalStateException("This is not a EndpointAccessContext.");
        }
        return (EndpointAccessContext)this;
    }

    public static enum TargetType {
        ROUTE,
        ENDPOINT;

    }
}

