/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.vaadin.security.spring.access.endpoint;

import de.codecamp.vaadin.security.spring.access.AccessContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.annotation.AnnotationUtils;

public class EndpointAccessContext
implements AccessContext {
    private final Method endpointMethod;
    private final HttpServletRequest request;

    public EndpointAccessContext(Method endpointMethod, HttpServletRequest request) {
        this.endpointMethod = endpointMethod;
        this.request = request;
    }

    @Override
    public AccessContext.TargetType getTargetType() {
        return AccessContext.TargetType.ENDPOINT;
    }

    public Method getEndpointMethod() {
        return this.endpointMethod;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public <A extends Annotation> Optional<A> findAnnotation(Class<A> annotationType) {
        return EndpointAccessContext.findAnnotation(this.endpointMethod, annotationType);
    }

    public static <A extends Annotation> Optional<A> findAnnotation(Method endpointMethod, Class<A> annotationType) {
        Annotation annotation = AnnotationUtils.findAnnotation((Method)endpointMethod, annotationType);
        if (annotation == null) {
            annotation = AnnotationUtils.findAnnotation(endpointMethod.getDeclaringClass(), annotationType);
        }
        return Optional.ofNullable(annotation);
    }
}

