/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.vaadin.security.spring.access.route;

import com.vaadin.flow.component.Component;
import de.codecamp.vaadin.security.spring.access.AccessRule;
import de.codecamp.vaadin.security.spring.access.SecuredAccess;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.core.annotation.AnnotationUtils;

public abstract class AbstractRouteAccessRuleRegistry
implements Serializable {
    private Map<Class<?>, AccessRule> rulesForTargetOrLayouts = new HashMap();
    private Map<String, AccessRule> rulesForPaths = new HashMap<String, AccessRule>();

    public Optional<AccessRule> getAccessRule(Class<?> targetOrLayout) {
        return this.doGetAccessRule(targetOrLayout, true);
    }

    public void setAccessRule(Class<? extends Component> targetOrLayout, AccessRule accessRule) {
        this.rulesForTargetOrLayouts.put(targetOrLayout, accessRule);
    }

    public void removeAccessRule(Class<? extends Component> targetOrLayout) {
        this.rulesForTargetOrLayouts.remove(targetOrLayout);
    }

    protected Optional<AccessRule> doGetAccessRule(Class<?> targetOrLayout, boolean includeAnnotations) {
        SecuredAccess securedAccess;
        AccessRule accessRule = this.rulesForTargetOrLayouts.get(targetOrLayout);
        if (accessRule != null) {
            return Optional.of(accessRule);
        }
        if (includeAnnotations && (securedAccess = (SecuredAccess)AnnotationUtils.findAnnotation(targetOrLayout, SecuredAccess.class)) != null) {
            return Optional.of(AccessRule.asCopyOf(securedAccess));
        }
        return Optional.empty();
    }

    public HashMap<String, AccessRule> getRegisteredAccessRulesForTargetsAndLayouts() {
        return new HashMap<String, AccessRule>(this.rulesForPaths);
    }

    public Optional<AccessRule> getAccessRule(String routePath) {
        return Optional.ofNullable(this.rulesForPaths.get(routePath));
    }

    public void setAccessRule(String routePath, AccessRule accessRule) {
        this.rulesForPaths.put(routePath, accessRule);
    }

    public void removeAccessRule(String routePath) {
        this.rulesForPaths.remove(routePath);
    }

    public HashMap<String, AccessRule> getRegisteredAccessRulesForPaths() {
        return new HashMap<String, AccessRule>(this.rulesForPaths);
    }
}

