/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.vaadin.security.spring.access.route;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.RouteNotFoundError;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.NavigationRouteTarget;
import com.vaadin.flow.router.internal.RouteTarget;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.SessionRouteRegistry;
import com.vaadin.flow.server.VaadinSession;
import de.codecamp.vaadin.security.spring.access.AccessEvaluator;
import de.codecamp.vaadin.security.spring.access.AccessRule;
import de.codecamp.vaadin.security.spring.access.VaadinSecurity;
import de.codecamp.vaadin.security.spring.access.route.RouteAccessContext;
import de.codecamp.vaadin.security.spring.access.route.RouteAccessControl;
import de.codecamp.vaadin.security.spring.access.route.RouteAccessDeniedException;
import de.codecamp.vaadin.security.spring.access.route.RouteAccessDeniedHandler;
import de.codecamp.vaadin.security.spring.access.route.SessionRouteAccessRuleRegistry;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRouteAccessControl
implements RouteAccessControl {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRouteAccessControl.class);
    private boolean denyUnsecured;
    private List<RouteAccessDeniedHandler> accessDeniedHandlers;

    public void setDenyUnsecured(boolean denyUnsecured) {
        this.denyUnsecured = denyUnsecured;
    }

    public void setAccessDeniedHandlers(List<RouteAccessDeniedHandler> accessDeniedHandlers) {
        this.accessDeniedHandlers = accessDeniedHandlers;
    }

    @Override
    public boolean hasAccessTo(Class<? extends Component> navigationTarget) {
        RouteRegistry sessionRegistry = SessionRouteRegistry.getSessionRegistry((VaadinSession)VaadinSession.getCurrent());
        RouteTarget routeTarget = sessionRegistry.getRouteTarget(navigationTarget, RouteParameters.empty());
        if (routeTarget == null) {
            LOG.warn("Could not find registered route for navigation target '{}'.", navigationTarget);
            return false;
        }
        String routePath = RouteConfiguration.forRegistry((RouteRegistry)sessionRegistry).getUrlBase(navigationTarget).orElse(null);
        if (routePath == null) {
            LOG.warn("Could not find registered route for navigation target '{}'.", navigationTarget);
            return false;
        }
        return this.hasAccess(null, routeTarget.getTarget(), routeTarget.getParentLayouts(), null);
    }

    @Override
    public boolean hasAccessTo(String routePath) {
        NavigationRouteTarget navigationRouteTarget = SessionRouteRegistry.getSessionRegistry((VaadinSession)VaadinSession.getCurrent()).getNavigationRouteTarget(routePath);
        if (!navigationRouteTarget.hasTarget()) {
            LOG.warn("Could not find navigation target for route path '{}'.", (Object)routePath);
            return false;
        }
        RouteTarget routeTarget = navigationRouteTarget.getRouteTarget();
        return this.hasAccess(routePath, routeTarget.getTarget(), routeTarget.getParentLayouts(), null);
    }

    @Override
    public void checkAccess(BeforeEnterEvent event) {
        LOG.trace("Checking access to route '{}' ({}).", (Object)event.getLocation().getPath(), (Object)event.getNavigationTarget().getName());
        if (HasErrorParameter.class.isAssignableFrom(event.getNavigationTarget()) || RouteNotFoundError.class.isAssignableFrom(event.getNavigationTarget()) && VaadinSecurity.check().isAuthenticated()) {
            LOG.debug("Access granted to error view '{}' at '{}'.", (Object)event.getNavigationTarget().getName(), (Object)event.getLocation().getPath());
            return;
        }
        if (event.getNavigationTarget().getName().contains("ClientViewPlaceholder")) {
            LOG.debug("Ignoring navigation to client-side view at '{}'.", (Object)event.getLocation().getPath());
            return;
        }
        boolean hasAccess = this.hasAccess(event.getLocation().getPath(), event.getNavigationTarget(), event.getLayouts(), event.getUI().getSession());
        if (hasAccess) {
            LOG.debug("Access granted to route '{}' ({}).", (Object)event.getLocation().getPath(), (Object)event.getNavigationTarget().getName());
            return;
        }
        LOG.debug("Access denied to route '{}' ({}).", (Object)event.getLocation().getPath(), (Object)event.getNavigationTarget().getName());
        this.onAccessDenied(event);
    }

    protected boolean hasAccess(String routePath, Class<? extends Component> navigationTarget, List<Class<? extends RouterLayout>> parentLayouts, VaadinSession vaadinSession) {
        if (vaadinSession == null) {
            vaadinSession = VaadinSession.getCurrent();
        }
        if (vaadinSession == null) {
            throw new IllegalStateException("No VaadinSession available.");
        }
        boolean secured = false;
        boolean hasAccess = true;
        ArrayList<Class<Object>> targetAndLayouts = new ArrayList<Class<Object>>();
        targetAndLayouts.add(navigationTarget);
        targetAndLayouts.addAll(parentLayouts);
        SessionRouteAccessRuleRegistry accessRuleRegistry = SessionRouteAccessRuleRegistry.getSessionRegistry(vaadinSession);
        for (Class clazz : targetAndLayouts) {
            AccessEvaluator evaluator;
            AccessRule accessRule = null;
            if (clazz == navigationTarget) {
                accessRule = accessRuleRegistry.getAccessRule(routePath).orElse(null);
            }
            if (accessRule == null) {
                accessRule = accessRuleRegistry.getAccessRule(clazz).orElse(null);
            }
            if (accessRule == null) continue;
            secured = true;
            if (accessRule.evaluator() != null && !(evaluator = (AccessEvaluator)vaadinSession.getService().getInstantiator().getOrCreate(accessRule.evaluator())).hasAccess(new RouteAccessContext(clazz))) {
                hasAccess = false;
                break;
            }
            String expression = accessRule.expression();
            if (expression == null) {
                expression = "isAuthenticated()";
            }
            if (!VaadinSecurity.hasAccess(expression)) {
                hasAccess = false;
                break;
            }
            if (accessRule.checkLayout()) continue;
            break;
        }
        if (this.denyUnsecured && !secured) {
            hasAccess = false;
        }
        return hasAccess;
    }

    protected void onAccessDenied(BeforeEnterEvent event) {
        if (event.hasForwardTarget() || event.hasRerouteTarget() || event.hasErrorParameter()) {
            return;
        }
        for (RouteAccessDeniedHandler handler : this.accessDeniedHandlers) {
            handler.handleAccessDenied(event);
            if (!event.hasForwardTarget() && !event.hasRerouteTarget() && !event.hasErrorParameter()) continue;
            return;
        }
        if (!(event.hasForwardTarget() || event.hasRerouteTarget() || event.hasErrorParameter())) {
            throw new RouteAccessDeniedException("Access denied");
        }
    }
}

