/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.vaadin.security.spring.access.route;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import de.codecamp.vaadin.security.spring.access.AccessRule;
import de.codecamp.vaadin.security.spring.access.route.AbstractRouteAccessRuleRegistry;
import de.codecamp.vaadin.security.spring.access.route.ApplicationRouteAccessRuleRegistry;
import de.codecamp.vaadin.security.spring.access.route.SessionRouteAccessRuleRegistry;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Optional;

public class RouteAccessConfiguration
implements Serializable {
    private AbstractRouteAccessRuleRegistry registry;

    private RouteAccessConfiguration(AbstractRouteAccessRuleRegistry registry) {
        this.registry = registry;
    }

    public static RouteAccessConfiguration forApplicationScope() {
        VaadinContext context = VaadinService.getCurrent().getContext();
        if (context == null) {
            throw new IllegalStateException("VaadinContext not found. Application scope only available in request or UI threads or in ServiceInitLister.");
        }
        return new RouteAccessConfiguration(ApplicationRouteAccessRuleRegistry.getApplicationRegistry(context));
    }

    public static RouteAccessConfiguration forSessionScope() {
        VaadinSession session = VaadinSession.getCurrent();
        if (session == null) {
            throw new IllegalStateException("VaadinSession not found. Session scope only available in request or UI threads.");
        }
        return new RouteAccessConfiguration(SessionRouteAccessRuleRegistry.getSessionRegistry(session));
    }

    public void setAccessRule(Class<? extends Component> targetOrLayout, AccessRule accessRule) {
        this.registry.setAccessRule(targetOrLayout, accessRule);
    }

    public void removeAccessRule(Class<? extends Component> targetOrLayout) {
        this.registry.removeAccessRule(targetOrLayout);
    }

    public Optional<AccessRule> getAccessRule(Class<?> targetOrLayout) {
        return this.registry.getAccessRule(targetOrLayout);
    }

    public HashMap<String, AccessRule> getRegisteredAccessRulesForTargetsAndLayouts() {
        return this.registry.getRegisteredAccessRulesForTargetsAndLayouts();
    }

    public void setAccessRule(String routePath, AccessRule accessRule) {
        this.registry.setAccessRule(routePath, accessRule);
    }

    public void removeAccessRule(String routePath) {
        this.registry.removeAccessRule(routePath);
    }

    public Optional<AccessRule> getAccessRule(String routePath) {
        return this.registry.getAccessRule(routePath);
    }

    public HashMap<String, AccessRule> getRegisteredAccessRulesForPaths() {
        return this.registry.getRegisteredAccessRulesForPaths();
    }
}

