/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.vaadin.security.spring.access.route;

import de.codecamp.vaadin.security.spring.access.AccessContext;
import java.lang.annotation.Annotation;
import java.util.Optional;
import org.springframework.core.annotation.AnnotationUtils;

public class RouteAccessContext
implements AccessContext {
    private final Class<?> accessedTargetOrLayout;

    public RouteAccessContext(Class<?> targetOrLayout) {
        this.accessedTargetOrLayout = targetOrLayout;
    }

    @Override
    public AccessContext.TargetType getTargetType() {
        return AccessContext.TargetType.ROUTE;
    }

    public Class<?> getAccessedTargetOrLayout() {
        return this.accessedTargetOrLayout;
    }

    @Override
    public <A extends Annotation> Optional<A> findAnnotation(Class<A> annotationType) {
        return this.findAnnotation(this.accessedTargetOrLayout, annotationType);
    }

    public <A extends Annotation> Optional<A> findAnnotation(Class<?> targetOrLayout, Class<A> annotationType) {
        return Optional.ofNullable(AnnotationUtils.findAnnotation(targetOrLayout, annotationType));
    }
}

