/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.vaadin.security.spring.access.route;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterListener;
import com.vaadin.flow.router.ListenerPriority;
import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.UIInitListener;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import de.codecamp.vaadin.security.spring.access.route.DefaultRouteAccessDeniedError;
import de.codecamp.vaadin.security.spring.access.route.RouteAccessControl;
import de.codecamp.vaadin.security.spring.access.route.RouteAccessDeniedException;
import java.io.Serializable;
import java.util.Collections;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class RouteAccessControlServiceInitListener
implements VaadinServiceInitListener {
    private static final VaadinAccessControlAdapter ACCESS_CONTROL_ADAPTER = new VaadinAccessControlAdapter();
    private static final SecurityContextSessionBinder SECURITY_CONTEXT_SESSION_BINDER = new SecurityContextSessionBinder();

    public void serviceInit(ServiceInitEvent serviceInitEvent) {
        serviceInitEvent.getSource().addUIInitListener((UIInitListener & Serializable)uiInitEvent -> {
            uiInitEvent.getUI().addBeforeEnterListener((BeforeEnterListener)ACCESS_CONTROL_ADAPTER);
            uiInitEvent.getUI().addBeforeEnterListener((BeforeEnterListener)SECURITY_CONTEXT_SESSION_BINDER);
        });
        ApplicationRouteRegistry routeRegistry = ApplicationRouteRegistry.getInstance((VaadinContext)serviceInitEvent.getSource().getContext());
        if (routeRegistry.getConfiguration().getExceptionHandlerByClass(RouteAccessDeniedException.class) == null) {
            routeRegistry.setErrorNavigationTargets(Collections.singleton(DefaultRouteAccessDeniedError.class));
        }
    }

    @ListenerPriority(value=0x7FFFFFFF)
    private static class SecurityContextSessionBinder
    implements BeforeEnterListener {
        private SecurityContextSessionBinder() {
        }

        public void beforeEnter(BeforeEnterEvent event) {
            SecurityContext securityContext = SecurityContextHolder.getContext();
            event.getUI().getSession().setAttribute(SecurityContext.class, (Object)securityContext);
        }
    }

    @ListenerPriority(value=0x7FFFFFF5)
    private static class VaadinAccessControlAdapter
    implements BeforeEnterListener {
        private VaadinAccessControlAdapter() {
        }

        public void beforeEnter(BeforeEnterEvent event) {
            ((RouteAccessControl)Instantiator.get((UI)event.getUI()).getOrCreate(RouteAccessControl.class)).checkAccess(event);
        }
    }
}

