/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.vaadin.security.spring.authentication;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.router.BeforeEnterEvent;
import de.codecamp.vaadin.security.spring.access.VaadinSecurity;
import de.codecamp.vaadin.security.spring.access.route.RouteAccessDeniedHandler;
import de.codecamp.vaadin.security.spring.authentication.AuthenticationResult;
import de.codecamp.vaadin.security.spring.authentication.AuthenticationResultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Order(value=0x7FFFFFFF)
public class StandardAuthenticationHandlers
implements AuthenticationResultHandler,
RouteAccessDeniedHandler {
    public static final int ORDER = Integer.MAX_VALUE;
    private static final Logger LOG = LoggerFactory.getLogger(StandardAuthenticationHandlers.class);
    private static final String DATA_ORIGINAL_TARGET = "VaadinAuthenticationOriginalTarget";
    private String mainRoute;
    private String loginRoute;

    public void setMainRoute(String mainRoute) {
        this.mainRoute = mainRoute;
    }

    public void setLoginRoute(String loginRoute) {
        this.loginRoute = loginRoute;
    }

    @Override
    public boolean handleAuthenticationResult(AuthenticationResult result) {
        if (result.isSuccess()) {
            String originalTarget = StandardAuthenticationHandlers.recallOriginalTarget(UI.getCurrent());
            boolean onLoginView = UI.getCurrent().getInternals().getActiveViewLocation().getPath().equals(this.loginRoute);
            if (onLoginView) {
                if (originalTarget == null || originalTarget.trim().isEmpty()) {
                    LOG.debug("Navigating from login route to main route '{}'.", (Object)this.mainRoute);
                    UI.getCurrent().navigate(this.mainRoute);
                } else {
                    LOG.debug("Navigating from login route to original target route '{}'.", (Object)originalTarget);
                    UI.getCurrent().navigate(originalTarget);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void handleAccessDenied(BeforeEnterEvent event) {
        if (!VaadinSecurity.check().isFullyAuthenticated()) {
            String originalTarget = event.getLocation().getPathWithQueryParameters();
            if (originalTarget.equals(".")) {
                originalTarget = "";
            }
            StandardAuthenticationHandlers.storeOriginalTarget(event.getUI(), originalTarget);
            LOG.debug("Forwarding to login route '{}'.", (Object)this.loginRoute);
            event.forwardTo(this.loginRoute);
        }
    }

    public static void storeOriginalTarget(UI ui, String originalTarget) {
        ComponentUtil.setData((Component)ui, (String)DATA_ORIGINAL_TARGET, (Object)originalTarget);
    }

    public static String recallOriginalTarget(UI ui) {
        String originalTarget = (String)ComponentUtil.getData((Component)ui, (String)DATA_ORIGINAL_TARGET);
        if (originalTarget != null) {
            ComponentUtil.setData((Component)ui, (String)DATA_ORIGINAL_TARGET, null);
        }
        return originalTarget;
    }
}

