/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.vaadin.security.spring.authentication;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import de.codecamp.vaadin.security.spring.authentication.AuthenticationResult;
import de.codecamp.vaadin.security.spring.authentication.AuthenticationResultHandler;
import de.codecamp.vaadin.security.spring.authentication.VaadinAuthenticationService;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardAuthenticationService
implements VaadinAuthenticationService {
    private static final Logger LOG = LoggerFactory.getLogger(StandardAuthenticationService.class);
    private String loginProcessingClientUrl;
    private String logoutProcessingClientUrl;
    private List<AuthenticationResultHandler> authenticationResultHandlers;

    public void setLoginProcessingClientUrl(String loginProcessingClientUrl) {
        this.loginProcessingClientUrl = loginProcessingClientUrl;
    }

    public void setLogoutProcessingClientUrl(String logoutProcessingClientUrl) {
        this.logoutProcessingClientUrl = logoutProcessingClientUrl;
    }

    public void setAuthenticationResultHandlers(List<AuthenticationResultHandler> authenticationResultHandlers) {
        this.authenticationResultHandlers = authenticationResultHandlers;
    }

    @Override
    public void login(Component commComponent, String username, String password, boolean rememberMe, AuthenticationResultHandler primaryHandler) {
        Objects.requireNonNull(commComponent, "commComponent must not be null");
        Objects.requireNonNull(username, "username must not be null");
        Objects.requireNonNull(password, "password must not be null");
        if (!commComponent.getElement().isEnabled()) {
            throw new IllegalStateException("The communication component must not be disabled for the login to work.");
        }
        JsonObject loginData = Json.createObject();
        loginData.put("username", username);
        loginData.put("password", password);
        loginData.put("remember-me", rememberMe);
        AtomicReference<DomListenerRegistration> listenerRegistration = new AtomicReference<DomListenerRegistration>();
        listenerRegistration.set(commComponent.getElement().addEventListener("login-done", (DomEventListener & Serializable)event -> {
            try {
                AuthenticationResult result;
                try {
                    result = this.retrieveLoginResult();
                }
                catch (RuntimeException ex) {
                    LOG.error("An error occurred while trying to retrieve the login result.", (Throwable)ex);
                    result = AuthenticationResult.failure(ex);
                }
                this.handleResult(result, primaryHandler);
            }
            finally {
                Optional.ofNullable((DomListenerRegistration)listenerRegistration.get()).ifPresent(Registration::remove);
            }
        }));
        String loginPostUrl = this.loginProcessingClientUrl;
        String loginScript = "let element = this; const loginData  = " + loginData.toJson() + "; const urlData  = new URLSearchParams(); for (var key in loginData) { urlData.set(key, loginData[key]); }; fetch('" + loginPostUrl + "', { method: 'POST', body: urlData }) .finally(() => { element.dispatchEvent(new Event('login-done')); });";
        commComponent.getElement().executeJs(loginScript, new Serializable[0]);
    }

    private AuthenticationResult retrieveLoginResult() {
        VaadinSession session = VaadinSession.getCurrent();
        AuthenticationResult result = (AuthenticationResult)session.getAttribute(AuthenticationResult.class);
        if (result == null) {
            throw new IllegalStateException("VaadinAuthenticationResult not available. It seems VaadinAuthenticationSuccessHandler and/or VaadinAuthenticationFailureHandler are not set up correctly.");
        }
        session.setAttribute(AuthenticationResult.class, null);
        return result;
    }

    private void handleResult(AuthenticationResult result, AuthenticationResultHandler primaryHandler) {
        AuthenticationResultHandler h;
        ArrayList<AuthenticationResultHandler> handlers = new ArrayList<AuthenticationResultHandler>();
        if (primaryHandler != null) {
            handlers.add(primaryHandler);
        }
        if (this.authenticationResultHandlers != null) {
            handlers.addAll(this.authenticationResultHandlers);
        }
        Iterator iterator = handlers.iterator();
        while (iterator.hasNext() && !(h = (AuthenticationResultHandler)iterator.next()).handleAuthenticationResult(result)) {
        }
    }

    @Override
    public void logout(Component commComponent) {
        Objects.requireNonNull(commComponent, "commComponent must not be null");
        String logoutPostUrl = this.logoutProcessingClientUrl;
        String logoutScript = "let element = this; fetch('" + logoutPostUrl + "', { method: 'POST' }) .then(response => { window.location.href = response.url; });";
        commComponent.getElement().executeJs(logoutScript, new Serializable[0]);
    }
}

