/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.vaadin.security.spring.authentication;

import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterListener;
import com.vaadin.flow.router.ListenerPriority;
import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.UIInitListener;
import com.vaadin.flow.server.VaadinServiceInitListener;
import de.codecamp.vaadin.security.spring.access.AccessRule;
import de.codecamp.vaadin.security.spring.access.VaadinSecurity;
import de.codecamp.vaadin.security.spring.access.route.RouteAccessConfiguration;
import de.codecamp.vaadin.security.spring.authentication.StandardAuthenticationHandlers;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardAuthenticationServiceInitListener
implements VaadinServiceInitListener {
    private static final Logger LOG = LoggerFactory.getLogger(StandardAuthenticationServiceInitListener.class);
    private final LoginRouteAccessListener loginRouteAccessListener = new LoginRouteAccessListener();
    private String loginRoute;
    private String mainRoute;

    public void setLoginRoute(String loginRoute) {
        this.loginRoute = loginRoute;
    }

    public void setMainRoute(String mainRoute) {
        this.mainRoute = mainRoute;
    }

    public void serviceInit(ServiceInitEvent serviceInitEvent) {
        serviceInitEvent.getSource().addUIInitListener((UIInitListener & Serializable)uiInitEvent -> uiInitEvent.getUI().addBeforeEnterListener((BeforeEnterListener)this.loginRouteAccessListener));
        LOG.debug("Setting access rule for login route '{}'.", (Object)this.loginRoute);
        RouteAccessConfiguration.forApplicationScope().setAccessRule(this.loginRoute, AccessRule.of("permitAll"));
    }

    @ListenerPriority(value=2147483627)
    private class LoginRouteAccessListener
    implements BeforeEnterListener {
        private LoginRouteAccessListener() {
        }

        public void beforeEnter(BeforeEnterEvent event) {
            if (event.getLocation().getPath().equals(StandardAuthenticationServiceInitListener.this.loginRoute) && VaadinSecurity.check().isFullyAuthenticated()) {
                String originalTarget = StandardAuthenticationHandlers.recallOriginalTarget(event.getUI());
                if (originalTarget == null || originalTarget.trim().isEmpty()) {
                    LOG.debug("Already fully authenticated. Forwarding from login route to main route '{}'.", (Object)StandardAuthenticationServiceInitListener.this.mainRoute);
                    event.forwardTo(StandardAuthenticationServiceInitListener.this.mainRoute);
                } else {
                    LOG.debug("Already fully authenticated. Forwarding from login route to original target route '{}'.", (Object)originalTarget);
                    event.forwardTo(originalTarget);
                }
            }
        }
    }
}

