/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.vaadin.security.spring.config;

import com.vaadin.flow.spring.security.RequestUtil;
import de.codecamp.vaadin.security.spring.authentication.VaadinAuthenticationFailureHandler;
import de.codecamp.vaadin.security.spring.authentication.VaadinAuthenticationSuccessHandler;
import de.codecamp.vaadin.security.spring.autoconfigure.VaadinSecurityProperties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class VaadinSecurityConfigurer {
    public void configure(HttpSecurity http) throws Exception {
        String[] stringArray;
        ApplicationContext applicationContext = (ApplicationContext)http.getSharedObject(ApplicationContext.class);
        VaadinSecurityProperties properties = (VaadinSecurityProperties)applicationContext.getBean(VaadinSecurityProperties.class);
        RequestUtil requestUtil = (RequestUtil)applicationContext.getBean(RequestUtil.class);
        if (properties.getUiRootUrl().isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "/**";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = properties.getUiRootUrl();
            stringArray = stringArray3;
            stringArray3[1] = properties.getUiRootUrl() + "/**";
        }
        String[] rootPatterns = stringArray;
        RequestMatcher[] requestMatcherArray = new RequestMatcher[1];
        requestMatcherArray[0] = arg_0 -> ((RequestUtil)requestUtil).isFrameworkInternalRequest(arg_0);
        RequestMatcher[] requestMatcherArray2 = new RequestMatcher[1];
        requestMatcherArray2[0] = arg_0 -> ((RequestUtil)requestUtil).isEndpointRequest(arg_0);
        ((HttpSecurity.RequestMatcherConfigurer)((HttpSecurity.RequestMatcherConfigurer)http.requestMatchers().requestMatchers(requestMatcherArray)).requestMatchers(requestMatcherArray2)).antMatchers(rootPatterns);
        RequestMatcher[] requestMatcherArray3 = new RequestMatcher[1];
        requestMatcherArray3[0] = arg_0 -> ((RequestUtil)requestUtil).isFrameworkInternalRequest(arg_0);
        RequestMatcher[] requestMatcherArray4 = new RequestMatcher[1];
        requestMatcherArray4[0] = arg_0 -> ((RequestUtil)requestUtil).isEndpointRequest(arg_0);
        http.csrf().ignoringRequestMatchers(requestMatcherArray3).ignoringRequestMatchers(requestMatcherArray4).ignoringAntMatchers(rootPatterns);
        VaadinSecurityProperties.StandardAuth standardAuthProperties = properties.getStandardAuth();
        if (standardAuthProperties.isEnabled()) {
            ((FormLoginConfigurer)((FormLoginConfigurer)http.formLogin().loginProcessingUrl(standardAuthProperties.getLoginProcessingUrl())).successHandler((AuthenticationSuccessHandler)new VaadinAuthenticationSuccessHandler())).failureHandler((AuthenticationFailureHandler)new VaadinAuthenticationFailureHandler());
            http.logout().logoutUrl(standardAuthProperties.getLogoutProcessingUrl()).logoutSuccessUrl((String)StringUtils.defaultIfBlank((CharSequence)standardAuthProperties.getLogoutSuccessUrl(), (CharSequence)((String)StringUtils.defaultIfBlank((CharSequence)properties.getUiRootUrl(), (CharSequence)"/"))));
        }
    }
}

